/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen;

import com.benryan.ppt.autoshapes.Autoshape;
import com.benryan.ppt.autoshapes.path.PathCreator;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class NotchedCircularArrow
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{-32000.0, -32000.0, 32000.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(-32000, -32000);
    private static Point extent = new Point(64000, 64000);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            adjustments = newAdjustments;
        }
        this.guides = new double[28];
        this.guides[0] = adjustments[0];
        this.guides[1] = adjustments[1];
        this.guides[2] = adjustments[2];
        this.guides[3] = 32000.0 * Math.sqrt(1.0 - this.guides[0] * this.guides[0] / 1.024E9);
        this.guides[4] = 32000.0 * Math.sqrt(1.0 - this.guides[1] * this.guides[1] / 1.024E9);
        this.guides[5] = 32000.0 * Math.sqrt(1.0 - this.guides[2] * this.guides[2] / 1.024E9);
        this.guides[6] = 0.0 - this.guides[3];
        this.guides[7] = 0.0 - this.guides[4];
        this.guides[8] = 0.0 - this.guides[5];
        this.guides[9] = 0.0 + this.guides[4] - this.guides[0];
        this.guides[10] = this.guides[9] > 0.0 ? this.guides[4] : this.guides[0];
        this.guides[11] = this.guides[9] > 0.0 ? this.guides[1] : this.guides[6];
        this.guides[12] = 0.0 + this.guides[5] - this.guides[0];
        this.guides[13] = this.guides[12] > 0.0 ? this.guides[5] : this.guides[0];
        this.guides[14] = this.guides[12] > 0.0 ? this.guides[2] : this.guides[3];
        this.guides[15] = this.guides[11] + 0.0 - 1.0;
        this.guides[16] = this.guides[14] + 1.0 - 0.0;
        this.guides[17] = 0.0 + this.guides[14] - this.guides[3];
        this.guides[18] = this.guides[17] > 0.0 ? this.guides[8] : this.guides[13];
        this.guides[19] = this.guides[17] > 0.0 ? this.guides[0] : this.guides[13];
        this.guides[20] = this.guides[17] > 0.0 ? this.guides[3] : this.guides[16];
        this.guides[21] = 0.0 + this.guides[6] - this.guides[11];
        this.guides[22] = this.guides[21] > 0.0 ? this.guides[7] : this.guides[10];
        this.guides[23] = this.guides[21] > 0.0 ? this.guides[0] : this.guides[10];
        this.guides[24] = this.guides[21] > 0.0 ? this.guides[6] : this.guides[15];
        this.guides[25] = Math.min(this.guides[10], this.guides[13]);
        this.guides[26] = Math.max(this.guides[8], this.guides[7]);
        this.guides[27] = Math.max(this.guides[26], this.guides[0]);
        this.textBoxRect = new double[][]{{this.guides[27], this.guides[11], this.guides[25], this.guides[14]}};
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        boolean nofill = false;
        boolean nostroke = false;
        PathCreator cr = new PathCreator();
        Shape sh = path = new GeneralPath();
        cr.clockwiseArc(path, new double[]{-32000.0, -32000.0, 32000.0, 32000.0, this.guides[10], this.guides[11], this.guides[13], this.guides[14], -32000.0, -32000.0, 32000.0, 32000.0, this.guides[18], this.guides[14], this.guides[19], this.guides[20]});
        cr.lineTo(path, new double[]{0.0, this.guides[20], 0.0, this.guides[24]});
        cr.clockwiseArcTo(path, new double[]{-32000.0, -32000.0, 32000.0, 32000.0, this.guides[23], this.guides[24], this.guides[22], this.guides[11]});
        path.closePath();
        sh = at.createTransformedShape(path);
        if (!nofill && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return NotchedCircularArrow.extent.x;
    }

    @Override
    public double getHeight() {
        return NotchedCircularArrow.extent.y;
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
    }
}

