/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen;

import com.benryan.ppt.autoshapes.Autoshape;
import com.benryan.ppt.autoshapes.path.PathCreator;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Moon
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{10800.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private static Point extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            adjustments = newAdjustments;
        }
        this.guides = new double[17];
        this.guides[0] = adjustments[0];
        this.guides[1] = 21600.0 - adjustments[0];
        this.guides[2] = adjustments[0] * adjustments[0] / this.guides[1];
        this.guides[3] = 4.6656E8 / this.guides[1];
        this.guides[4] = this.guides[3] * 2.0 / 1.0;
        this.guides[5] = this.guides[4] + 0.0 - this.guides[2];
        this.guides[6] = this.guides[5] + 0.0 - adjustments[0];
        this.guides[7] = this.guides[5] * 1.0 / 2.0;
        this.guides[8] = this.guides[7] + 0.0 - adjustments[0];
        this.guides[9] = this.guides[8] * 1.0 / 2.0;
        this.guides[10] = 10800.0 - this.guides[9];
        this.guides[11] = this.guides[9] + 10800.0 - 0.0;
        this.guides[12] = adjustments[0] * 9598.0 / 32768.0;
        this.guides[13] = 21600.0 - this.guides[12];
        this.guides[14] = 10800.0 * Math.sqrt(1.0 - this.guides[13] * this.guides[13] / 4.6656E8);
        this.guides[15] = 10800.0 - this.guides[14];
        this.guides[16] = this.guides[14] + 10800.0 - 0.0;
        this.textBoxRect = new double[][]{{this.guides[12], this.guides[15], this.guides[0], this.guides[16]}};
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        boolean nofill = false;
        boolean nostroke = false;
        PathCreator cr = new PathCreator();
        Shape sh = path = new GeneralPath();
        cr.moveTo(path, new double[]{21600.0, 0.0});
        cr.ellipticalQuadrantX(path, new double[]{0.0, 10800.0, 21600.0, 21600.0});
        cr.clockwiseArcTo(path, new double[]{this.guides[0], this.guides[10], this.guides[6], this.guides[11], 21600.0, 21600.0, 21600.0, 0.0});
        path.closePath();
        sh = at.createTransformedShape(path);
        if (!nofill && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return Moon.extent.x;
    }

    @Override
    public double getHeight() {
        return Moon.extent.y;
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
    }
}

