/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.autoshapes.gen;

import com.benryan.ppt.autoshapes.Autoshape;
import com.benryan.ppt.autoshapes.path.PathCreator;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class BentUpArrow
implements Autoshape {
    public static double[] DefaultAdjustments = new double[]{9257.0, 18514.0, 7200.0};
    private double[] adjustments;
    private double[] guides;
    private double[][] textBoxRect;
    private static Point origin = new Point(0, 0);
    private static Point extent = new Point(21600, 21600);

    @Override
    public void initShape(double[] adjustments) {
        if (adjustments == null || adjustments.length == 0) {
            adjustments = DefaultAdjustments;
        } else if (adjustments.length < DefaultAdjustments.length) {
            double[] newAdjustments = new double[DefaultAdjustments.length];
            System.arraycopy(DefaultAdjustments, adjustments.length, newAdjustments, adjustments.length, DefaultAdjustments.length - adjustments.length);
            System.arraycopy(adjustments, 0, newAdjustments, 0, adjustments.length);
            adjustments = newAdjustments;
        }
        this.guides = new double[18];
        this.guides[0] = adjustments[0];
        this.guides[1] = adjustments[1];
        this.guides[2] = adjustments[2];
        this.guides[3] = adjustments[0] * 1.0 / 2.0;
        this.guides[4] = this.guides[3] + 10800.0 - 0.0;
        this.guides[5] = 21600.0 + adjustments[0] - adjustments[1];
        this.guides[6] = adjustments[1] + adjustments[2] - 0.0;
        this.guides[7] = this.guides[6] * 1.0 / 2.0;
        this.guides[8] = adjustments[1] * 2.0 / 1.0;
        this.guides[9] = this.guides[8] + 0.0 - 21600.0;
        this.guides[10] = 21600.0 * this.guides[0] / this.guides[1];
        this.guides[11] = 21600.0 * this.guides[4] / this.guides[1];
        this.guides[12] = 21600.0 * this.guides[5] / this.guides[1];
        this.guides[13] = 21600.0 * this.guides[7] / this.guides[1];
        this.guides[14] = adjustments[1] * 1.0 / 2.0;
        this.guides[15] = this.guides[5] + 0.0 - this.guides[4];
        this.guides[16] = this.guides[0] + 0.0 - this.guides[4];
        this.guides[17] = this.guides[2] * this.guides[15] / this.guides[16];
        this.textBoxRect = new double[][]{{0.0, this.guides[12], this.guides[1], 21600.0}, {this.guides[5], this.guides[17], this.guides[1], 21600.0}};
    }

    @Override
    public void createShape(Graphics2D g, Paint fill, Paint draw, AffineTransform at) {
        GeneralPath path;
        boolean nofill = false;
        boolean nostroke = false;
        PathCreator cr = new PathCreator();
        Shape sh = path = new GeneralPath();
        cr.moveTo(path, new double[]{this.guides[4], 0.0});
        cr.lineTo(path, new double[]{this.guides[0], this.guides[2], this.guides[5], this.guides[2], this.guides[5], this.guides[12], 0.0, this.guides[12], 0.0, 21600.0, this.guides[1], 21600.0, this.guides[1], this.guides[2], 21600.0, this.guides[2]});
        path.closePath();
        sh = at.createTransformedShape(path);
        if (!nofill && fill != null) {
            g.setPaint(fill);
            g.fill(sh);
        }
        if (!nostroke && draw != null) {
            g.setPaint(draw);
            g.draw(sh);
        }
        nofill = false;
        nostroke = false;
        path = new GeneralPath();
    }

    @Override
    public double[] getDefaultAdjustments() {
        return DefaultAdjustments;
    }

    @Override
    public double getWidth() {
        return BentUpArrow.extent.x;
    }

    @Override
    public double getHeight() {
        return BentUpArrow.extent.y;
    }

    @Override
    public Point getOrigin() {
        return origin;
    }

    public double[][] getTextBoxRect() {
        return this.textBoxRect;
    }

    @Override
    public void setDimensions(double width, double height) {
    }
}

