/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.util;

import com.benryan.ppt.api.util.ImageOptions;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageOptionsFilter {
    private final ImageOptions imageOptions;

    public ImageOptionsFilter(ImageOptions imageOptions) {
        this.imageOptions = imageOptions;
    }

    public BufferedImage filter(BufferedImage img) {
        img = this.resizeImage(img);
        img = this.handleTransparency(img);
        return img;
    }

    private BufferedImage resizeImage(BufferedImage img) {
        boolean hasFilter;
        double cropTop = this.imageOptions.getCropTop();
        double cropLeft = this.imageOptions.getCropLeft();
        double cropBottom = this.imageOptions.getCropBottom();
        double cropRight = this.imageOptions.getCropRight();
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        int x = 0;
        int y = 0;
        int width = imgWidth;
        int height = imgHeight;
        boolean bl = hasFilter = cropTop > 0.0 || cropLeft > 0.0 || cropBottom > 0.0 || cropRight > 0.0;
        if (hasFilter) {
            if (cropTop > 0.0) {
                y = (int)((double)imgHeight * cropTop);
                height -= y;
            }
            if (cropLeft > 0.0) {
                x = (int)((double)imgWidth * cropLeft);
                width -= x;
            }
            if (cropBottom > 0.0) {
                height -= (int)((double)imgHeight * cropBottom);
            }
            if (cropRight > 0.0) {
                width -= (int)((double)imgWidth * cropRight);
            }
            return img.getSubimage(x, y, Math.max(width, 1), Math.max(height, 1));
        }
        return img;
    }

    private BufferedImage handleTransparency(BufferedImage img) {
        Color transparency = this.imageOptions.getTransparency();
        if (transparency != null) {
            WritableRaster raster = img.getAlphaRaster();
            if (raster == null) {
                BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), 2);
                newImg.getGraphics().drawImage(img, 0, 0, null);
                img = newImg;
            }
            int trgb = transparency.getRGB();
            int height = img.getHeight();
            int width = img.getWidth();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (img.getRGB(x, y) != trgb) continue;
                    img.setRGB(x, y, trgb & 0xFFFFFF);
                }
            }
            return img;
        }
        return img;
    }
}

