/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.usermodel;

import com.benryan.ppt.api.model.MasterSheet;
import com.benryan.ppt.api.model.Sheet;
import com.benryan.ppt.api.model.TextRun;
import com.benryan.ppt.api.model.textproperties.BitMaskTextProp;
import com.benryan.ppt.api.model.textproperties.CharFlagsTextProp;
import com.benryan.ppt.api.model.textproperties.ParagraphFlagsTextProp;
import com.benryan.ppt.api.model.textproperties.TextProp;
import com.benryan.ppt.api.model.textproperties.TextPropCollection;
import com.benryan.ppt.api.record.ColorSchemeAtom;
import com.benryan.ppt.api.record.TextRulerAtom;
import com.benryan.ppt.api.usermodel.EscherCharacterRun;
import com.benryan.ppt.api.usermodel.SlideShow;
import java.awt.Color;

public class RichTextRun
implements EscherCharacterRun {
    private TextRun parentRun;
    private SlideShow slideShow;
    private int startPos;
    private int length;
    private String _fontname;
    private TextPropCollection paragraphStyle;
    private TextPropCollection characterStyle;
    private boolean sharingParagraphStyle;
    private boolean sharingCharacterStyle;

    public RichTextRun(TextRun parent, int startAt, int len) {
        this(parent, startAt, len, null, null, false, false);
    }

    public RichTextRun(TextRun parent, int startAt, int len, TextPropCollection pStyle, TextPropCollection cStyle, boolean pShared, boolean cShared) {
        this.parentRun = parent;
        this.startPos = startAt;
        this.length = len;
        this.paragraphStyle = pStyle;
        this.characterStyle = cStyle;
        this.sharingParagraphStyle = pShared;
        this.sharingCharacterStyle = cShared;
    }

    public void supplyTextProps(TextPropCollection pStyle, TextPropCollection cStyle, boolean pShared, boolean cShared) {
        if (this.paragraphStyle != null || this.characterStyle != null) {
            throw new IllegalStateException("Can't call supplyTextProps if run already has some");
        }
        this.paragraphStyle = pStyle;
        this.characterStyle = cStyle;
        this.sharingParagraphStyle = pShared;
        this.sharingCharacterStyle = cShared;
    }

    public void supplySlideShow(SlideShow ss) {
        this.slideShow = ss;
        if (this._fontname != null) {
            this.setFontName(this._fontname);
            this._fontname = null;
        }
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public String getText() {
        return this.parentRun.getText().substring(this.startPos, this.startPos + this.length);
    }

    public String getRawText() {
        return this.parentRun.getRawText().substring(this.startPos, this.startPos + this.length);
    }

    public void setText(String text) {
        this.length = text.length();
        this.parentRun.changeTextInRichTextRun(this, text);
    }

    public void updateStartPosition(int startAt) {
        this.startPos = startAt;
    }

    private boolean isCharFlagsTextPropVal(int index) {
        return this.getFlag(true, index);
    }

    private boolean getFlag(boolean isCharacter, int index) {
        String propname;
        TextPropCollection props;
        if (isCharacter) {
            props = this.characterStyle;
            propname = CharFlagsTextProp.NAME;
        } else {
            props = this.paragraphStyle;
            propname = ParagraphFlagsTextProp.NAME;
        }
        BitMaskTextProp prop = null;
        if (props != null) {
            prop = (BitMaskTextProp)props.findByName(propname);
        }
        if (prop == null) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = sheet.getMasterSheet();
            if (master != null) {
                prop = (BitMaskTextProp)master.getStyleAttribute(txtype, this.getIndentLevel(), propname, isCharacter);
            }
        }
        return prop == null ? false : prop.getSubValue(index);
    }

    private void setCharFlagsTextPropVal(int index, boolean value) {
        this.setFlag(true, index, value);
    }

    private void setFlag(boolean isCharacter, int index, boolean value) {
        String propname;
        TextPropCollection props;
        if (isCharacter) {
            props = this.characterStyle;
            propname = CharFlagsTextProp.NAME;
        } else {
            props = this.paragraphStyle;
            propname = ParagraphFlagsTextProp.NAME;
        }
        if (props == null) {
            this.parentRun.ensureStyleAtomPresent();
            props = isCharacter ? this.characterStyle : this.paragraphStyle;
        }
        BitMaskTextProp prop = (BitMaskTextProp)this.fetchOrAddTextProp(props, propname);
        prop.setSubValue(value, index);
    }

    private TextProp fetchOrAddTextProp(TextPropCollection textPropCol, String textPropName) {
        TextProp tp = textPropCol.findByName(textPropName);
        if (tp == null) {
            tp = textPropCol.addWithName(textPropName);
        }
        return tp;
    }

    private int getCharTextPropVal(String propName) {
        TextProp prop = null;
        if (this.characterStyle != null) {
            prop = this.characterStyle.findByName(propName);
        }
        if (prop == null) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = null;
            master = sheet instanceof MasterSheet ? (MasterSheet)sheet : sheet.getMasterSheet();
            if (master != null) {
                prop = master.getStyleAttribute(txtype, this.getIndentLevel(), propName, true);
            }
        }
        return prop == null ? -1 : prop.getValue();
    }

    private int getParaTextPropVal(String propName) {
        TextProp prop = null;
        if (this.paragraphStyle != null) {
            prop = this.paragraphStyle.findByName(propName);
        }
        if (prop == null) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = null;
            master = sheet instanceof MasterSheet ? (MasterSheet)sheet : sheet.getMasterSheet();
            if (master != null) {
                prop = master.getStyleAttribute(txtype, this.getIndentLevel(), propName, false);
            }
        }
        return prop == null ? -1 : prop.getValue();
    }

    private void setParaTextPropVal(String propName, int val) {
        if (this.paragraphStyle == null) {
            this.parentRun.ensureStyleAtomPresent();
        }
        TextProp tp = this.fetchOrAddTextProp(this.paragraphStyle, propName);
        tp.setValue(val);
    }

    private void setCharTextPropVal(String propName, int val) {
        if (this.characterStyle == null) {
            this.parentRun.ensureStyleAtomPresent();
        }
        TextProp tp = this.fetchOrAddTextProp(this.characterStyle, propName);
        tp.setValue(val);
    }

    @Override
    public boolean isBold() {
        return this.isCharFlagsTextPropVal(0);
    }

    public void setBold(boolean bold) {
        this.setCharFlagsTextPropVal(0, bold);
    }

    @Override
    public boolean isItalic() {
        return this.isCharFlagsTextPropVal(1);
    }

    public void setItalic(boolean italic) {
        this.setCharFlagsTextPropVal(1, italic);
    }

    @Override
    public boolean isUnderlined() {
        return this.isCharFlagsTextPropVal(2);
    }

    @Override
    public int getTextPosition() {
        int pos = this.getCharTextPropVal("offset");
        return pos;
    }

    public void setUnderlined(boolean underlined) {
        this.setCharFlagsTextPropVal(2, underlined);
    }

    @Override
    public int getFontSize() {
        return this.getCharTextPropVal("font.size");
    }

    public void setFontSize(int fontSize) {
        this.setCharTextPropVal("font.size", fontSize);
    }

    public void setFontName(String fontName) {
        if (this.slideShow == null) {
            this._fontname = fontName;
        } else {
            int fontIdx = this.slideShow.getFontCollection().addFont(fontName);
            this.setCharTextPropVal("font.index", fontIdx);
        }
    }

    @Override
    public String getFontName() {
        if (this.slideShow == null) {
            return this._fontname;
        }
        int fontIdx = this.getCharTextPropVal("font.index");
        if (fontIdx == -1) {
            return null;
        }
        return this.slideShow.getFontCollection().getFontWithId(fontIdx);
    }

    @Override
    public String getBulletFontName() {
        if (this.slideShow == null) {
            return this._fontname;
        }
        if (this.hasFont()) {
            int fontIdx = this.getParaTextPropVal("bullet.font");
            if (fontIdx == -1) {
                return null;
            }
            return this.slideShow.getFontCollection().getFontWithId(fontIdx);
        }
        return this.getFontName();
    }

    @Override
    public Color getFontColor() {
        int rgb = this.getCharTextPropVal("font.color");
        return this.convertColor(rgb);
    }

    private Color convertColor(int rgb) {
        if ((rgb & 0xFF000000) != -33554432) {
            int idx = rgb >> 24;
            ColorSchemeAtom ca = this.parentRun.getSheet().getColorScheme();
            if (idx >= 0 && idx <= 7) {
                rgb = ca.getColor(idx);
            }
        }
        Color tmp = new Color(rgb, true);
        return new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
    }

    public void setFontColor(int bgr) {
        this.setCharTextPropVal("font.color", bgr);
    }

    public void setFontColor(Color color) {
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 254).getRGB();
        this.setFontColor(rgb);
    }

    public void setAlignment(int align) {
        this.setParaTextPropVal("alignment", align);
    }

    @Override
    public int getAlignment() {
        return this.getParaTextPropVal("alignment");
    }

    @Override
    public int getIndentLevel() {
        return this.paragraphStyle == null ? 0 : (int)this.paragraphStyle.getReservedField();
    }

    public void setBullet(boolean flag) {
        this.setFlag(false, 0, flag);
    }

    @Override
    public boolean isBullet() {
        return this.getFlag(false, 0);
    }

    public boolean hasColor() {
        return this.getFlag(false, 2);
    }

    public boolean hasSize() {
        return this.getFlag(false, 3);
    }

    public boolean hasFont() {
        return this.getFlag(false, 1);
    }

    public void setBulletChar(char c) {
        this.setParaTextPropVal("bullet.char", c);
    }

    @Override
    public char getBulletChar() {
        return (char)this.getParaTextPropVal("bullet.char");
    }

    @Override
    public double getBulletSize() {
        if (this.hasSize()) {
            int size = this.getParaTextPropVal("bullet.size");
            if (size < 0) {
                return (double)size * 96.0 / 576.0;
            }
            return size;
        }
        return 100.0;
    }

    @Override
    public double getLineSpacing() {
        int size = this.getParaTextPropVal("linespacing");
        if (size < 0) {
            return (double)size * 96.0 / 576.0;
        }
        return size;
    }

    @Override
    public double getSpaceBefore() {
        int size = this.getParaTextPropVal("spacebefore");
        if (size < 0) {
            return (double)size * 96.0 / 576.0;
        }
        return size;
    }

    @Override
    public double getSpaceAfter() {
        int size = this.getParaTextPropVal("spaceafter");
        if (size < 0) {
            return (double)size * 96.0 / 576.0;
        }
        return size;
    }

    @Override
    public Color getBulletColor() {
        if (this.hasColor()) {
            int rgb = this.getParaTextPropVal("bullet.color");
            return this.convertColor(rgb);
        }
        return this.getFontColor();
    }

    public void setBulletOffset(int offset) {
        this.setParaTextPropVal("bullet.offset", offset * 576 / 96);
    }

    @Override
    public int getBulletOffset() {
        TextRulerAtom tra = this.parentRun.getTextRulerAtom();
        int level = this.getIndentLevel();
        if (tra != null && tra.hasIndent(level)) {
            return (int)tra.getIndent(level);
        }
        return this.getParaTextPropVal("bullet.offset") * 96 / 576;
    }

    public void setTextOffset(int offset) {
        this.setParaTextPropVal("text.offset", offset * 576 / 96);
    }

    @Override
    public int getTextOffset() {
        TextRulerAtom tra = this.parentRun.getTextRulerAtom();
        int level = this.getIndentLevel();
        if (tra != null && tra.hasLeftMargin(level)) {
            return (int)tra.getLeftMargin(level);
        }
        return this.getParaTextPropVal("text.offset") * 96 / 576;
    }

    public TextPropCollection _getRawParagraphStyle() {
        return this.paragraphStyle;
    }

    public TextPropCollection _getRawCharacterStyle() {
        return this.characterStyle;
    }

    public boolean _isParagraphStyleShared() {
        return this.sharingParagraphStyle;
    }

    public boolean _isCharacterStyleShared() {
        return this.sharingCharacterStyle;
    }

    @Override
    public int getStartIndex() {
        return this.startPos;
    }
}

