/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.usermodel;

import com.benryan.fonts.FontManager;
import com.benryan.ppt.PptRenderer;
import com.benryan.ppt.api.usermodel.EscherCharacterRun;
import com.benryan.ppt.api.usermodel.IParagraph;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Paragraph
implements IParagraph,
AttributedCharacterIterator {
    private static HashSet attrSet = new HashSet();
    ArrayList _richTextRuns = new ArrayList();
    int _start;
    int _end;
    int _curIdx;
    int _curChar;
    String _curString;
    boolean _softBreak;

    public Paragraph(int start, int end, boolean softBreak) {
        this._start = start;
        this._end = end;
        this._softBreak = softBreak;
    }

    public Paragraph(ArrayList runs, boolean softBreak) {
        this._richTextRuns = runs;
        this._softBreak = softBreak;
    }

    public void initCharacterIterator() {
        this._curIdx = 0;
        this._curChar = 0;
        EscherCharacterRun run = this.getCurrentRun();
        this._curString = run.getText();
    }

    @Override
    public EscherCharacterRun getStyle() {
        return (EscherCharacterRun)this._richTextRuns.get(0);
    }

    public void addRun(EscherCharacterRun run) {
        this._richTextRuns.add(run);
    }

    @Override
    public boolean isSoftBreak() {
        return this._softBreak;
    }

    public ArrayList getRichTextRuns() {
        return this._richTextRuns;
    }

    public Set getAllAttributeKeys() {
        return attrSet;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        EscherCharacterRun run = this.getCurrentRun();
        return this.getAttributeForRun(attribute, run);
    }

    private Object getAttributeForRun(AttributedCharacterIterator.Attribute attribute, EscherCharacterRun run) {
        if (attribute == TextAttribute.FONT) {
            int styleVal = 0;
            if (run.isBold()) {
                styleVal |= 1;
            }
            if (run.isItalic()) {
                styleVal |= 2;
            }
            Font f = FontManager.resolveFont((String)run.getFontName(), (int)styleVal, (int)((int)((double)run.getFontSize() * PptRenderer.POINTS_TO_PIXELS)));
            return f;
        }
        if (attribute == TextAttribute.SUPERSCRIPT) {
            int pos = run.getTextPosition();
            if (pos < 0) {
                return TextAttribute.SUPERSCRIPT_SUB;
            }
            if (pos > 0) {
                return TextAttribute.SUPERSCRIPT_SUPER;
            }
            return new Integer(0);
        }
        if (attribute == TextAttribute.FOREGROUND) {
            return run.getFontColor();
        }
        if (attribute == TextAttribute.UNDERLINE) {
            if (run.isUnderlined()) {
                return TextAttribute.UNDERLINE_ON;
            }
            return null;
        }
        return null;
    }

    public Map getAttributes() {
        EscherCharacterRun run = this.getCurrentRun();
        HashMap<TextAttribute, Serializable> map = new HashMap<TextAttribute, Serializable>();
        int styleVal = 0;
        if (run.isBold()) {
            styleVal |= 1;
        }
        if (run.isItalic()) {
            styleVal |= 2;
        }
        Font f = FontManager.resolveFont((String)run.getFontName(), (int)styleVal, (int)((int)((double)run.getFontSize() * PptRenderer.POINTS_TO_PIXELS)));
        map.put(TextAttribute.FONT, f);
        int pos = run.getTextPosition();
        if (pos < 0) {
            map.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
        } else if (pos > 0) {
            map.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        } else {
            map.put(TextAttribute.SUPERSCRIPT, new Integer(0));
        }
        map.put(TextAttribute.FOREGROUND, run.getFontColor());
        if (run.isUnderlined()) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        return map;
    }

    @Override
    public int getRunLimit() {
        EscherCharacterRun run = this.getCurrentRun();
        return this.getRunLimit(run);
    }

    private int getRunLimit(EscherCharacterRun run) {
        return run.getStartIndex() + run.getLength();
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        Object val = this.getAttribute(attribute);
        int limit = this.getRunLimit();
        for (int x = this._curIdx + 1; x < this._richTextRuns.size(); ++x) {
            EscherCharacterRun nextRun = (EscherCharacterRun)this._richTextRuns.get(x);
            Object nextVal = this.getAttributeForRun(attribute, nextRun);
            if (val != null) {
                if (!val.equals(nextVal)) break;
                limit = this.getRunLimit(nextRun);
                continue;
            }
            if (val != nextVal) break;
            limit = this.getRunLimit(nextRun);
        }
        return limit;
    }

    public int getRunLimit(Set arg0) {
        return this.getRunLimit();
    }

    @Override
    public int getRunStart() {
        EscherCharacterRun run = this.getCurrentRun();
        return this.getRunStart(run);
    }

    private EscherCharacterRun getCurrentRun() {
        EscherCharacterRun run = (EscherCharacterRun)this._richTextRuns.get(this._curIdx);
        return run;
    }

    private int getRunStart(EscherCharacterRun run) {
        return run.getStartIndex();
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        return this.getRunStart();
    }

    public int getRunStart(Set arg0) {
        return this.getRunStart();
    }

    @Override
    public char current() {
        return this._curString.charAt(this._curChar);
    }

    @Override
    public char first() {
        this._curIdx = 0;
        this._curChar = 0;
        EscherCharacterRun run = this.getCurrentRun();
        this._curString = run.getText();
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return ((EscherCharacterRun)this._richTextRuns.get(0)).getStartIndex();
    }

    @Override
    public int getEndIndex() {
        EscherCharacterRun run = (EscherCharacterRun)this._richTextRuns.get(this._richTextRuns.size() - 1);
        return run.getStartIndex() + run.getText().length();
    }

    @Override
    public int getIndex() {
        return this.getCurrentRun().getStartIndex() + this._curChar;
    }

    @Override
    public char last() {
        this._curIdx = this._richTextRuns.size() - 1;
        EscherCharacterRun run = this.getCurrentRun();
        this._curString = run.getText();
        this._curChar = this._curString.length() - 1;
        return this.current();
    }

    @Override
    public char next() {
        EscherCharacterRun run = this.getCurrentRun();
        if (this._curString.length() > this._curChar + 1) {
            ++this._curChar;
        } else if (this._richTextRuns.size() > this._curIdx + 1) {
            ++this._curIdx;
            this._curChar = 0;
            this._curString = this.getCurrentRun().getText();
        } else {
            return '\uffff';
        }
        return this.current();
    }

    @Override
    public char previous() {
        if (this._curChar != 0) {
            --this._curChar;
        } else if (this._curIdx > 0) {
            --this._curIdx;
            this._curString = this.getCurrentRun().getText();
            this._curChar = this._curString.length() - 1;
        } else {
            return '\uffff';
        }
        return this.current();
    }

    @Override
    public char setIndex(int idx) {
        this._curIdx = 0;
        while (this._curIdx < this._richTextRuns.size()) {
            EscherCharacterRun run = this.getCurrentRun();
            int start = this.getRunStart(run);
            if (start <= idx && this.getRunLimit(run) > idx) {
                this._curChar = idx - start;
                return this.current();
            }
            ++this._curIdx;
        }
        return ' ';
    }

    @Override
    public AttributedCharacterIterator getIterator() {
        this.initCharacterIterator();
        return this;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static {
        attrSet.add(TextAttribute.FONT);
        attrSet.add(TextAttribute.SUPERSCRIPT);
        attrSet.add(TextAttribute.FOREGROUND);
        attrSet.add(TextAttribute.UNDERLINE);
    }
}

