/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.model.textproperties.TextProp;
import com.benryan.ppt.api.model.textproperties.TextPropCollection;
import com.benryan.ppt.api.record.RecordAtom;
import com.benryan.ppt.api.record.StyleTextPropAtom;
import java.io.IOException;
import java.io.OutputStream;

public class TxMasterStyleAtom
extends RecordAtom {
    private static final int MAX_INDENT = 5;
    private byte[] _header = new byte[8];
    private static long _type = 4003L;
    private byte[] _data;
    private TextPropCollection[] prstyles;
    private TextPropCollection[] chstyles;

    protected TxMasterStyleAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, this._data.length);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public TextPropCollection[] getCharacterStyles() {
        return this.chstyles;
    }

    public TextPropCollection[] getParagraphStyles() {
        return this.prstyles;
    }

    public int getTextType() {
        return LittleEndian.getShort(this._header, 0) >> 4;
    }

    protected void init() {
        int type = this.getTextType();
        int pos = 0;
        short levels = LittleEndian.getShort(this._data, 0);
        pos += 2;
        this.prstyles = new TextPropCollection[levels];
        this.chstyles = new TextPropCollection[levels];
        for (short j = 0; j < levels; j = (short)(j + 1)) {
            if (type >= 5) {
                short val = LittleEndian.getShort(this._data, pos);
                pos += 2;
            }
            int head = LittleEndian.getInt(this._data, pos);
            pos += 4;
            TextPropCollection prprops = new TextPropCollection(0);
            pos += prprops.buildTextPropList(head, this.getParagraphProps(type, j), this._data, pos);
            this.prstyles[j] = prprops;
            head = LittleEndian.getInt(this._data, pos);
            pos += 4;
            TextPropCollection chprops = new TextPropCollection(0);
            pos += chprops.buildTextPropList(head, this.getCharacterProps(type, j), this._data, pos);
            this.chstyles[j] = chprops;
        }
    }

    protected TextProp[] getParagraphProps(int type, int level) {
        return StyleTextPropAtom.paragraphTextPropTypes;
    }

    protected TextProp[] getCharacterProps(int type, int level) {
        return StyleTextPropAtom.characterTextPropTypes;
    }
}

