/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.record.RecordAtom;
import com.benryan.ppt.api.record.RecordTypes;
import java.io.IOException;
import java.io.OutputStream;

public class TextRulerAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private int[] _tabStops;
    private int[] _tabAlignments;
    private int _numLevels;
    private int _defaultTab;
    private int _leftMargin0;
    private int _indent0;
    private int _leftMargin1;
    private int _indent1;
    private int _leftMargin2;
    private int _indent2;
    private int _leftMargin3;
    private int _indent3;
    private int _leftMargin4;
    private int _indent4;
    private int _flag;

    protected TextRulerAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._flag = LittleEndian.getInt(source, start += 8);
        start += 4;
        if ((this._flag & 2) != 0) {
            this._numLevels = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 1) != 0) {
            this._defaultTab = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 4) != 0) {
            int numTabs = LittleEndian.getShort(source, start);
            start += 2;
            this._tabStops = new int[numTabs];
            this._tabAlignments = new int[numTabs];
            for (int x = 0; x < numTabs; ++x) {
                this._tabStops[x] = LittleEndian.getShort(source, start);
                this._tabAlignments[x] = LittleEndian.getShort(source, start += 2);
                start += 2;
            }
        }
        if ((this._flag & 8) != 0) {
            this._leftMargin0 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x100) != 0) {
            this._indent0 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x10) != 0) {
            this._leftMargin1 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x200) != 0) {
            this._indent1 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x20) != 0) {
            this._leftMargin2 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x400) != 0) {
            this._indent2 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x40) != 0) {
            this._leftMargin3 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x800) != 0) {
            this._indent3 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x80) != 0) {
            this._leftMargin4 = LittleEndian.getShort(source, start);
            start += 2;
        }
        if ((this._flag & 0x1000) != 0) {
            this._indent4 = LittleEndian.getShort(source, start);
            start += 2;
        }
    }

    public boolean hasIndent(int level) {
        switch (level) {
            case 0: {
                return this.hasIndent0();
            }
            case 1: {
                return this.hasIndent1();
            }
            case 2: {
                return this.hasIndent2();
            }
            case 3: {
                return this.hasIndent3();
            }
            case 4: {
                return this.hasIndent4();
            }
        }
        return false;
    }

    public boolean hasLeftMargin(int level) {
        switch (level) {
            case 0: {
                return this.hasLeftMargin0();
            }
            case 1: {
                return this.hasLeftMargin1();
            }
            case 2: {
                return this.hasLeftMargin2();
            }
            case 3: {
                return this.hasLeftMargin3();
            }
            case 4: {
                return this.hasLeftMargin4();
            }
        }
        return false;
    }

    public boolean hasIndent0() {
        return (this._flag & 0x100) != 0;
    }

    public boolean hasIndent1() {
        return (this._flag & 0x200) != 0;
    }

    public boolean hasIndent2() {
        return (this._flag & 0x400) != 0;
    }

    public boolean hasIndent3() {
        return (this._flag & 0x800) != 0;
    }

    public boolean hasIndent4() {
        return (this._flag & 0x1000) != 0;
    }

    public boolean hasLeftMargin0() {
        return (this._flag & 8) != 0;
    }

    public boolean hasLeftMargin1() {
        return (this._flag & 0x10) != 0;
    }

    public boolean hasLeftMargin2() {
        return (this._flag & 0x20) != 0;
    }

    public boolean hasLeftMargin3() {
        return (this._flag & 0x40) != 0;
    }

    public boolean hasLeftMargin4() {
        return (this._flag & 0x80) != 0;
    }

    @Override
    public long getRecordType() {
        return RecordTypes.TextRulerAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream o) throws IOException {
    }

    public double getLeftMargin(int level) {
        switch (level) {
            case 0: {
                return (double)this._leftMargin0 * 0.16666666666666666;
            }
            case 1: {
                return (double)this._leftMargin1 * 0.16666666666666666;
            }
            case 2: {
                return (double)this._leftMargin2 * 0.16666666666666666;
            }
            case 3: {
                return (double)this._leftMargin3 * 0.16666666666666666;
            }
            case 4: {
                return (double)this._leftMargin4 * 0.16666666666666666;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public double getIndent(int level) {
        switch (level) {
            case 0: {
                return (double)this._indent0 * 0.16666666666666666;
            }
            case 1: {
                return (double)this._indent1 * 0.16666666666666666;
            }
            case 2: {
                return (double)this._indent2 * 0.16666666666666666;
            }
            case 3: {
                return (double)this._indent3 * 0.16666666666666666;
            }
            case 4: {
                return (double)this._indent4 * 0.16666666666666666;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }
}

