/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.apache.poi.util.StringUtil;
import com.benryan.ppt.api.record.RecordAtom;
import java.io.IOException;
import java.io.OutputStream;

public class TextCharsAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 4000L;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromUnicodeLE(this._text);
    }

    public void setText(String text) {
        this._text = new byte[text.length() * 2];
        StringUtil.putUnicodeLE(text, this._text, 0);
        LittleEndian.putInt(this._header, 4, this._text.length);
    }

    protected TextCharsAtom(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._text = new byte[len - 8];
        System.arraycopy(source, start + 8, this._text, 0, len - 8);
    }

    public TextCharsAtom() {
        this._header = new byte[]{0, 0, -96, 15, 0, 0, 0, 0};
        this._text = new byte[0];
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._text);
    }
}

