/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.ArrayUtil;
import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.util.MutableByteArrayOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class RecordContainer
extends Record {
    protected Record[] _children;
    private Boolean changingChildRecordsLock = new Boolean(true);

    @Override
    public Record[] getChildRecords() {
        return this._children;
    }

    @Override
    public boolean isAnAtom() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findChildLocation(Record child) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            for (int i = 0; i < this._children.length; ++i) {
                if (!this._children[i].equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendChild(Record newChild) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            Record[] nc = new Record[this._children.length + 1];
            System.arraycopy(this._children, 0, nc, 0, this._children.length);
            nc[this._children.length] = newChild;
            this._children = nc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildAt(Record newChild, int position) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            this.appendChild(newChild);
            this.moveChildRecords(this._children.length - 1, position, 1);
        }
    }

    private void moveChildRecords(int oldLoc, int newLoc, int number) {
        if (oldLoc == newLoc) {
            return;
        }
        if (number == 0) {
            return;
        }
        if (oldLoc + number > this._children.length) {
            throw new IllegalArgumentException("Asked to move more records than there are!");
        }
        ArrayUtil.arrayMoveWithin(this._children, oldLoc, newLoc, number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendChildRecord(Record newChild) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            this.appendChild(newChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildAfter(Record newChild, Record after) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int loc = this.findChildLocation(after);
            if (loc == -1) {
                throw new IllegalArgumentException("Asked to add a new child after another record, but that record wasn't one of our children!");
            }
            this.addChildAt(newChild, loc + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildBefore(Record newChild, Record before) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int loc = this.findChildLocation(before);
            if (loc == -1) {
                throw new IllegalArgumentException("Asked to add a new child before another record, but that record wasn't one of our children!");
            }
            this.addChildAt(newChild, loc);
        }
    }

    public void moveChildBefore(Record child, Record before) {
        this.moveChildrenBefore(child, 1, before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildrenBefore(Record firstChild, int number, Record before) {
        if (number < 1) {
            return;
        }
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int newLoc = this.findChildLocation(before);
            if (newLoc == -1) {
                throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
            }
            int oldLoc = this.findChildLocation(firstChild);
            if (oldLoc == -1) {
                throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
            }
            this.moveChildRecords(oldLoc, newLoc, number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildrenAfter(Record firstChild, int number, Record after) {
        if (number < 1) {
            return;
        }
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int newLoc = this.findChildLocation(after);
            if (newLoc == -1) {
                throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
            }
            ++newLoc;
            int oldLoc = this.findChildLocation(firstChild);
            if (oldLoc == -1) {
                throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
            }
            this.moveChildRecords(oldLoc, newLoc, number);
        }
    }

    public void writeOut(byte headerA, byte headerB, long type, Record[] children, OutputStream out) throws IOException {
        if (out instanceof MutableByteArrayOutputStream) {
            MutableByteArrayOutputStream mout = (MutableByteArrayOutputStream)out;
            int oldSize = mout.getBytesWritten();
            mout.write(new byte[]{headerA, headerB});
            byte[] typeB = new byte[2];
            LittleEndian.putShort(typeB, (short)type);
            mout.write(typeB);
            mout.write(new byte[4]);
            for (int i = 0; i < children.length; ++i) {
                children[i].writeOut(mout);
            }
            int length = mout.getBytesWritten() - oldSize - 8;
            byte[] size = new byte[4];
            LittleEndian.putInt(size, 0, length);
            mout.overwrite(size, oldSize + 4);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(new byte[]{headerA, headerB});
            byte[] typeB = new byte[2];
            LittleEndian.putShort(typeB, (short)type);
            baos.write(typeB);
            baos.write(new byte[]{0, 0, 0, 0});
            for (int i = 0; i < children.length; ++i) {
                children[i].writeOut(baos);
            }
            byte[] toWrite = baos.toByteArray();
            LittleEndian.putInt(toWrite, 4, toWrite.length - 8);
            out.write(toWrite);
        }
    }
}

