/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.DefaultEscherRecordFactory;
import com.benryan.escher.api.EscherBSERecord;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.RecordAtom;
import com.benryan.ppt.api.record.RecordTypes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PPDrawingGroup
extends RecordAtom {
    private byte[] _header = new byte[8];
    private EscherContainerRecord dggContainer;

    protected PPDrawingGroup(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        DefaultEscherRecordFactory erf = new DefaultEscherRecordFactory();
        EscherRecord child = erf.createRecord(contents, 0);
        child.fillFields(contents, 0, erf);
        this.dggContainer = (EscherContainerRecord)child.getChild(0);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.PPDrawingGroup.typeID;
    }

    @Override
    public Record[] getChildRecords() {
        return null;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        List<EscherRecord> child = this.dggContainer.getChildRecords();
        for (int i = 0; i < child.size(); ++i) {
            EscherRecord r = child.get(i);
            if (r.getRecordId() == -4095) {
                EscherContainerRecord bstore = (EscherContainerRecord)r;
                ByteArrayOutputStream b2 = new ByteArrayOutputStream();
                List<EscherRecord> blip = bstore.getChildRecords();
                for (EscherBSERecord escherBSERecord : blip) {
                    byte[] b = new byte[44];
                    escherBSERecord.serialize(0, b);
                    b2.write(b);
                }
                byte[] bstorehead = new byte[8];
                LittleEndian.putShort(bstorehead, 0, bstore.getOptions());
                LittleEndian.putShort(bstorehead, 2, bstore.getRecordId());
                LittleEndian.putInt(bstorehead, 4, b2.size());
                bout.write(bstorehead);
                bout.write(b2.toByteArray());
                continue;
            }
            bout.write(r.serialize());
        }
        int size = bout.size();
        LittleEndian.putInt(this._header, 4, size + 8);
        out.write(this._header);
        byte[] dgghead = new byte[8];
        LittleEndian.putShort(dgghead, 0, this.dggContainer.getOptions());
        LittleEndian.putShort(dgghead, 2, this.dggContainer.getRecordId());
        LittleEndian.putInt(dgghead, 4, size);
        out.write(dgghead);
        out.write(bout.toByteArray());
    }

    public EscherContainerRecord getDggContainer() {
        return this.dggContainer;
    }
}

