/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.record.RecordAtom;
import com.benryan.ppt.api.record.RecordTypes;
import java.io.IOException;
import java.io.OutputStream;

public class OutlineTextRefAtom
extends RecordAtom {
    private byte[] _header;
    private int _index;

    protected OutlineTextRefAtom(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._index = LittleEndian.getInt(source, start + 8);
    }

    protected OutlineTextRefAtom() {
        this._index = 0;
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)this.getRecordType());
        LittleEndian.putInt(this._header, 4, 4);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.OutlineTextRefAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        byte[] recdata = new byte[4];
        LittleEndian.putInt(recdata, 0, this._index);
        out.write(recdata);
    }

    public void setTextIndex(int idx) {
        this._index = idx;
    }

    public int getTextIndex() {
        return this._index;
    }
}

