/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.ppt.api.record.ColorSchemeAtom;
import com.benryan.ppt.api.record.NotesAtom;
import com.benryan.ppt.api.record.PPDrawing;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.SheetContainer;
import java.io.IOException;
import java.io.OutputStream;

public class Notes
extends SheetContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1008L;
    private NotesAtom notesAtom;
    private PPDrawing ppDrawing;
    private ColorSchemeAtom _colorScheme;

    public NotesAtom getNotesAtom() {
        return this.notesAtom;
    }

    @Override
    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    protected Notes(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof NotesAtom) {
                this.notesAtom = (NotesAtom)this._children[i];
            }
            if (this._children[i] instanceof PPDrawing) {
                this.ppDrawing = (PPDrawing)this._children[i];
            }
            if (this.ppDrawing == null || !(this._children[i] instanceof ColorSchemeAtom)) continue;
            this._colorScheme = (ColorSchemeAtom)this._children[i];
        }
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }

    @Override
    public ColorSchemeAtom getColorScheme() {
        return this._colorScheme;
    }

    @Override
    public boolean doesSchemeFollowMaster() {
        return this.notesAtom.getFollowMasterScheme();
    }
}

