/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.ppt.api.record.ColorSchemeAtom;
import com.benryan.ppt.api.record.PPDrawing;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.SheetContainer;
import com.benryan.ppt.api.record.SlideAtom;
import com.benryan.ppt.api.record.TxMasterStyleAtom;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class MainMaster
extends SheetContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1016L;
    private SlideAtom slideAtom;
    private PPDrawing ppDrawing;
    private TxMasterStyleAtom[] txmasters;
    private ColorSchemeAtom[] clrscheme;
    private ColorSchemeAtom _colorScheme;

    public SlideAtom getSlideAtom() {
        return this.slideAtom;
    }

    @Override
    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    public TxMasterStyleAtom[] getTxMasterStyleAtoms() {
        return this.txmasters;
    }

    public ColorSchemeAtom[] getColorSchemeAtoms() {
        return this.clrscheme;
    }

    protected MainMaster(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        ArrayList<Record> tx = new ArrayList<Record>();
        ArrayList<Record> clr = new ArrayList<Record>();
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof SlideAtom) {
                this.slideAtom = (SlideAtom)this._children[i];
            } else if (this._children[i] instanceof PPDrawing) {
                this.ppDrawing = (PPDrawing)this._children[i];
            } else if (this._children[i] instanceof TxMasterStyleAtom) {
                tx.add(this._children[i]);
            } else if (this._children[i] instanceof ColorSchemeAtom) {
                clr.add(this._children[i]);
            }
            if (this.ppDrawing == null || !(this._children[i] instanceof ColorSchemeAtom) || !((ColorSchemeAtom)this._children[i]).isVersion(16)) continue;
            this._colorScheme = (ColorSchemeAtom)this._children[i];
        }
        this.txmasters = tx.toArray(new TxMasterStyleAtom[tx.size()]);
        this.clrscheme = clr.toArray(new ColorSchemeAtom[clr.size()]);
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }

    @Override
    public ColorSchemeAtom getColorScheme() {
        return this._colorScheme;
    }

    @Override
    public boolean doesSchemeFollowMaster() {
        return false;
    }
}

