/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.record.RecordAtom;
import com.benryan.ppt.api.record.RecordTypes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;

public class ExOleObjStg
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected ExOleObjStg() {
        this._data = new byte[0];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected ExOleObjStg(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public int getDataLength() {
        return LittleEndian.getInt(this._data, 0);
    }

    public InputStream getData() {
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(this._data, 4, this._data.length);
        return new InflaterInputStream(compressedStream);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExOleObjStg.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }
}

