/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.record.CString;
import com.benryan.ppt.api.record.ExHyperlinkAtom;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.RecordContainer;
import java.io.IOException;
import java.io.OutputStream;

public class ExHyperlink
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 4055L;
    private ExHyperlinkAtom linkAtom;
    private CString linkDetailsA;
    private CString linkDetailsB;

    public ExHyperlinkAtom getExHyperlinkAtom() {
        return this.linkAtom;
    }

    public String getLinkURL() {
        return this.linkDetailsB == null ? null : this.linkDetailsB.getText();
    }

    public String getLinkTitle() {
        return this.linkDetailsA == null ? null : this.linkDetailsA.getText();
    }

    public void setLinkURL(String url) {
        this.linkDetailsA.setText(url);
        if (this.linkDetailsB != null) {
            this.linkDetailsB.setText(url);
        }
    }

    public String _getDetailsA() {
        return this.linkDetailsA == null ? null : this.linkDetailsA.getText();
    }

    public String _getDetailsB() {
        return this.linkDetailsB == null ? null : this.linkDetailsB.getText();
    }

    protected ExHyperlink(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExHyperlinkAtom) {
            this.linkAtom = (ExHyperlinkAtom)this._children[0];
        } else {
            this.logger.log(7, "First child record wasn't a ExHyperlinkAtom, was of type " + this._children[0].getRecordType());
        }
        for (int i = 1; i < this._children.length; ++i) {
            if (this._children[i] instanceof CString) {
                if (this.linkDetailsA == null) {
                    this.linkDetailsA = (CString)this._children[i];
                    continue;
                }
                this.linkDetailsB = (CString)this._children[i];
                continue;
            }
            this.logger.log(7, "Record after ExHyperlinkAtom wasn't a CString, was of type " + this._children[1].getRecordType());
        }
    }

    public ExHyperlink() {
        this._children = new Record[3];
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)_type);
        CString csa = new CString();
        CString csb = new CString();
        csa.setCount(0);
        csb.setCount(16);
        this._children[0] = new ExHyperlinkAtom();
        this._children[1] = csa;
        this._children[2] = csb;
        this.findInterestingChildren();
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }
}

