/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.escher.api.EscherTextboxRecord;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.RecordContainer;
import com.benryan.ppt.api.record.RecordTypes;
import com.benryan.ppt.api.record.TextRulerAtom;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EscherTextboxWrapper
extends RecordContainer {
    private EscherTextboxRecord _escherRecord;
    private long _type;
    private int shapeId;

    public EscherTextboxRecord getEscherRecord() {
        return this._escherRecord;
    }

    public EscherTextboxWrapper(EscherTextboxRecord textbox) {
        this._escherRecord = textbox;
        this._type = this._escherRecord.getRecordId();
        byte[] data = this._escherRecord.getData();
        this._children = Record.findChildRecords(data, 0, data.length);
    }

    public EscherTextboxWrapper() {
        this._escherRecord = new EscherTextboxRecord();
        this._escherRecord.setRecordId((short)-4083);
        this._escherRecord.setOptions((short)15);
        this._children = new Record[0];
    }

    @Override
    public long getRecordType() {
        return this._type;
    }

    public TextRulerAtom getTextRuler() {
        Record[] children = this.getChildRecords();
        for (int x = 0; x < children.length; ++x) {
            if (children[x].getRecordType() != (long)RecordTypes.TextRulerAtom.typeID) continue;
            return (TextRulerAtom)children[x];
        }
        return null;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < this._children.length; ++i) {
            this._children[i].writeOut(baos);
        }
        byte[] data = baos.toByteArray();
        this._escherRecord.setData(data);
    }

    public int getShapeId() {
        return this.shapeId;
    }

    public void setShapeId(int id) {
        this.shapeId = id;
    }
}

