/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.record;

import com.benryan.ppt.api.record.DocumentAtom;
import com.benryan.ppt.api.record.Environment;
import com.benryan.ppt.api.record.ExObjList;
import com.benryan.ppt.api.record.HeadersFooters;
import com.benryan.ppt.api.record.PPDrawingGroup;
import com.benryan.ppt.api.record.PositionDependentRecordContainer;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.RecordTypes;
import com.benryan.ppt.api.record.SlideListWithText;
import java.io.IOException;
import java.io.OutputStream;

public class Document
extends PositionDependentRecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1000L;
    private DocumentAtom documentAtom;
    private Environment environment;
    private PPDrawingGroup ppDrawing;
    private SlideListWithText[] slwts;
    private ExObjList exObjList;
    private HeadersFooters headersFooters;

    public DocumentAtom getDocumentAtom() {
        return this.documentAtom;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PPDrawingGroup getPPDrawingGroup() {
        return this.ppDrawing;
    }

    public ExObjList getExObjList() {
        return this.exObjList;
    }

    public HeadersFooters getHeadersFooters() {
        return this.headersFooters;
    }

    public SlideListWithText[] getSlideListWithTexts() {
        return this.slwts;
    }

    public SlideListWithText getMasterSlideListWithText() {
        if (this.slwts.length > 0) {
            return this.slwts[0];
        }
        return null;
    }

    public SlideListWithText getSlideSlideListWithText() {
        if (this.slwts.length > 1) {
            return this.slwts[1];
        }
        return null;
    }

    public SlideListWithText getNotesSlideListWithText() {
        if (this.slwts.length > 2) {
            return this.slwts[2];
        }
        return null;
    }

    protected Document(byte[] source, int start, int len) {
        int i;
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        if (!(this._children[0] instanceof DocumentAtom)) {
            throw new IllegalStateException("The first child of a Document must be a DocumentAtom");
        }
        this.documentAtom = (DocumentAtom)this._children[0];
        int slwtcount = 0;
        for (i = 1; i < this._children.length; ++i) {
            if (this._children[i] instanceof SlideListWithText) {
                ++slwtcount;
            }
            if (this._children[i] instanceof Environment) {
                this.environment = (Environment)this._children[i];
            }
            if (this._children[i] instanceof PPDrawingGroup) {
                this.ppDrawing = (PPDrawingGroup)this._children[i];
            }
            if (this._children[i] instanceof ExObjList) {
                this.exObjList = (ExObjList)this._children[i];
            }
            if (!(this._children[i] instanceof HeadersFooters)) continue;
            this.headersFooters = (HeadersFooters)this._children[i];
        }
        if (slwtcount == 0) {
            this.logger.log(5, "No SlideListWithText's found - there should normally be at least one!");
        }
        if (slwtcount > 3) {
            this.logger.log(5, "Found " + slwtcount + " SlideListWithTexts - normally there should only be three!");
        }
        this.slwts = new SlideListWithText[slwtcount];
        slwtcount = 0;
        for (i = 1; i < this._children.length; ++i) {
            if (!(this._children[i] instanceof SlideListWithText)) continue;
            this.slwts[slwtcount] = (SlideListWithText)this._children[i];
            ++slwtcount;
        }
    }

    public void addSlideListWithText(SlideListWithText slwt) {
        Record endDoc = this._children[this._children.length - 1];
        if (endDoc.getRecordType() != (long)RecordTypes.EndDocument.typeID) {
            throw new IllegalStateException("The last child record of a Document should be EndDocument, but it was " + endDoc);
        }
        this.addChildBefore(slwt, endDoc);
        int newSize = this.slwts.length + 1;
        SlideListWithText[] nl = new SlideListWithText[newSize];
        System.arraycopy(this.slwts, 0, nl, 0, this.slwts.length);
        nl[nl.length - 1] = slwt;
        this.slwts = nl;
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }
}

