/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.model;

import com.benryan.apache.poi.util.StringUtil;
import com.benryan.ppt.api.model.EscherHostTextContainer;
import com.benryan.ppt.api.model.Hyperlink;
import com.benryan.ppt.api.model.Sheet;
import com.benryan.ppt.api.model.textproperties.TextPropCollection;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.RecordAtom;
import com.benryan.ppt.api.record.RecordContainer;
import com.benryan.ppt.api.record.StyleTextPropAtom;
import com.benryan.ppt.api.record.TextBytesAtom;
import com.benryan.ppt.api.record.TextCharsAtom;
import com.benryan.ppt.api.record.TextHeaderAtom;
import com.benryan.ppt.api.record.TextRulerAtom;
import com.benryan.ppt.api.usermodel.EscherCharacterRun;
import com.benryan.ppt.api.usermodel.Paragraph;
import com.benryan.ppt.api.usermodel.RichTextRun;
import com.benryan.ppt.api.usermodel.SlideShow;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TextRun
implements EscherHostTextContainer {
    protected TextHeaderAtom _headerAtom;
    protected TextBytesAtom _byteAtom;
    protected TextCharsAtom _charAtom;
    protected TextRulerAtom _rulerAtom;
    protected StyleTextPropAtom _styleAtom;
    protected boolean _isUnicode;
    protected RichTextRun[] _rtRuns;
    protected ArrayList<Paragraph> _paragraphs;
    protected Record[] _records;
    private SlideShow slideShow;
    private int slideIndex = -1;
    private Sheet sheet;
    private int shapeId;

    public TextRun(TextHeaderAtom tha, TextBytesAtom tba, StyleTextPropAtom sta) {
        this(tha, tba, null, sta);
    }

    public TextRun(TextHeaderAtom tha, TextCharsAtom tca, StyleTextPropAtom sta) {
        this(tha, null, tca, sta);
    }

    private TextRun(TextHeaderAtom tha, TextBytesAtom tba, TextCharsAtom tca, StyleTextPropAtom sta) {
        this._headerAtom = tha;
        this._styleAtom = sta;
        if (tba != null) {
            this._byteAtom = tba;
            this._isUnicode = false;
        } else {
            this._charAtom = tca;
            this._isUnicode = true;
        }
        String runRawText = this.getRawText();
        LinkedList pStyles = new LinkedList();
        LinkedList cStyles = new LinkedList();
        if (this._styleAtom != null) {
            this._styleAtom.setParentTextSize(runRawText.length());
            pStyles = this._styleAtom.getParagraphStyles();
            cStyles = this._styleAtom.getCharacterStyles();
        }
        this._paragraphs = new ArrayList();
        if (pStyles.size() == 0 || cStyles.size() == 0) {
            String[] pars = this.splitIntoParagraphs(runRawText);
            int offset = 0;
            for (int x = 0; x < pars.length; ++x) {
                char lastChar = pars[x].charAt(pars[x].length() - 1);
                boolean endsWithBreak = lastChar == '\u000b' || lastChar == '\r';
                int parLen = pars[x].length() - (endsWithBreak ? 1 : 0);
                Paragraph p = new Paragraph(offset, parLen, lastChar == '\u000b');
                RichTextRun rtr = new RichTextRun(this, offset, parLen > 0 ? parLen : 1);
                p.addRun(rtr);
                this._paragraphs.add(p);
                offset += pars[x].length();
            }
        } else {
            Vector rtrs = new Vector();
            int lastCProps = 0;
            int currentIdx = 0;
            int charsLeft = 0;
            for (int x = 0; x < pStyles.size() && currentIdx < runRawText.length(); ++x) {
                TextPropCollection pProps = (TextPropCollection)pStyles.get(x);
                int pLen = pProps.getCharactersCovered();
                if (currentIdx + pLen > runRawText.length()) {
                    pLen = runRawText.length() - currentIdx;
                }
                int paragraphEnd = currentIdx + pLen;
                String[] subParas = this.splitIntoParagraphs(runRawText.substring(currentIdx, paragraphEnd));
                int paragraphLen = 0;
                block2: for (int y = 0; y < subParas.length; ++y) {
                    boolean endsWithBreak;
                    paragraphLen = subParas[y].length();
                    paragraphEnd = currentIdx + paragraphLen;
                    char lastChar = subParas[y].charAt(paragraphLen - 1);
                    Paragraph p = new Paragraph(currentIdx, paragraphLen, lastChar == '\u000b');
                    this._paragraphs.add(p);
                    boolean bl = endsWithBreak = lastChar == '\u000b' || lastChar == '\r';
                    while (lastCProps < cStyles.size()) {
                        int cLen;
                        TextPropCollection cProps = (TextPropCollection)cStyles.get(lastCProps);
                        int n = cLen = charsLeft > 0 ? charsLeft : cProps.getCharactersCovered();
                        if (currentIdx + cLen > runRawText.length()) {
                            cLen = runRawText.length() - currentIdx;
                        }
                        int runLen = Math.min(cLen, paragraphLen);
                        charsLeft = 0;
                        int hackLen = Math.min(runLen, endsWithBreak ? paragraphLen - 1 : paragraphLen);
                        if (hackLen > 0 || subParas[y].length() == 1) {
                            RichTextRun rtr = new RichTextRun(this, paragraphEnd - paragraphLen, Math.max(hackLen, 1), pProps, cProps, false, false);
                            p.addRun(rtr);
                        }
                        currentIdx += runLen;
                        if ((paragraphLen -= runLen) <= 0) {
                            charsLeft = cLen - runLen;
                            if (charsLeft != 0) continue block2;
                            ++lastCProps;
                            continue block2;
                        }
                        ++lastCProps;
                    }
                }
            }
            this._rtRuns = new RichTextRun[rtrs.size()];
            rtrs.copyInto(this._rtRuns);
        }
        if (runRawText.endsWith("\r") || runRawText.endsWith("\u000b")) {
            Paragraph emptyPar = new Paragraph(runRawText.length(), 1, runRawText.endsWith("\u000b"));
            if (pStyles.size() > 0 && cStyles.size() > 0) {
                emptyPar.addRun(new RichTextRun(this, runRawText.length() - 1, 1, (TextPropCollection)pStyles.getLast(), (TextPropCollection)cStyles.getLast(), false, false));
            } else {
                emptyPar.addRun(new RichTextRun(this, runRawText.length() - 1, 1));
            }
            this._paragraphs.add(emptyPar);
        }
    }

    public synchronized void changeTextInRichTextRun(RichTextRun run, String s) {
        int runID = -1;
        for (int i = 0; i < this._rtRuns.length; ++i) {
            if (!run.equals(this._rtRuns[i])) continue;
            runID = i;
        }
        if (runID == -1) {
            throw new IllegalArgumentException("Supplied RichTextRun wasn't from this TextRun");
        }
        this.ensureStyleAtomPresent();
        TextPropCollection pCol = run._getRawParagraphStyle();
        TextPropCollection cCol = run._getRawCharacterStyle();
        int newSize = s.length();
        if (runID == this._rtRuns.length - 1) {
            ++newSize;
        }
        if (run._isParagraphStyleShared()) {
            pCol.updateTextSize(pCol.getCharactersCovered() - run.getLength() + s.length());
        } else {
            pCol.updateTextSize(newSize);
        }
        if (run._isCharacterStyleShared()) {
            cCol.updateTextSize(cCol.getCharactersCovered() - run.getLength() + s.length());
        } else {
            cCol.updateTextSize(newSize);
        }
        StringBuffer newText = new StringBuffer();
        for (int i = 0; i < this._rtRuns.length; ++i) {
            int newStartPos = newText.length();
            if (i != runID) {
                newText.append(this._rtRuns[i].getRawText());
            } else {
                newText.append(s);
            }
            if (i <= runID) continue;
            this._rtRuns[i].updateStartPosition(newStartPos);
        }
        this.storeText(newText.toString());
    }

    public synchronized void ensureStyleAtomPresent() {
        if (this._styleAtom != null) {
            return;
        }
        this._styleAtom = new StyleTextPropAtom(this.getRawText().length() + 1);
        RecordContainer runAtomsParent = this._headerAtom.getParentRecord();
        RecordAtom addAfter = this._byteAtom;
        if (this._byteAtom == null) {
            addAfter = this._charAtom;
        }
        runAtomsParent.addChildAfter(this._styleAtom, addAfter);
        if (this._rtRuns.length != 1) {
            throw new IllegalStateException("Needed to add StyleTextPropAtom when had many rich text runs");
        }
        this._rtRuns[0].supplyTextProps((TextPropCollection)this._styleAtom.getParagraphStyles().get(0), (TextPropCollection)this._styleAtom.getCharacterStyles().get(0), false, false);
    }

    @Override
    public int getDefaultVertAlign() {
        int type = this.getRunType();
        switch (type) {
            case 0: 
            case 6: {
                return 1;
            }
        }
        return 0;
    }

    public Hyperlink[] getHyperlinks() {
        return Hyperlink.find(this);
    }

    @Override
    public List<Paragraph> getParagraphs() {
        return this._paragraphs;
    }

    public String getRawText() {
        if (this._isUnicode) {
            return this._charAtom.getText();
        }
        return this._byteAtom.getText();
    }

    public EscherCharacterRun[] getRichTextRuns() {
        return this._rtRuns;
    }

    public int getRunType() {
        return this._headerAtom.getTextType();
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public int getSlideIndex() {
        return this.slideIndex;
    }

    public String getText() {
        String rawText = this.getRawText();
        String text = rawText.replace('\r', '\n').replace('\u000b', '\n');
        return text;
    }

    public TextRulerAtom getTextRulerAtom() {
        return this._rulerAtom;
    }

    public void setRunType(int type) {
        this._headerAtom.setTextType(type);
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
        for (int x = 0; x < this._paragraphs.size(); ++x) {
            Paragraph p = this._paragraphs.get(x);
            ArrayList runs = p.getRichTextRuns();
            for (int y = 0; y < runs.size(); ++y) {
                RichTextRun run = (RichTextRun)runs.get(y);
                run.supplySlideShow(sheet.getSlideShow());
            }
        }
    }

    public void setSlideIndex(int slideIndex) {
        this.slideIndex = slideIndex;
    }

    public synchronized void setText(String s) {
        this.storeText(s);
        RichTextRun fst = this._rtRuns[0];
        for (int i = 0; i < this._rtRuns.length; ++i) {
            this._rtRuns[i] = null;
        }
        this._rtRuns = new RichTextRun[1];
        this._rtRuns[0] = fst;
        if (this._styleAtom != null) {
            LinkedList pStyles = this._styleAtom.getParagraphStyles();
            while (pStyles.size() > 1) {
                pStyles.removeLast();
            }
            LinkedList cStyles = this._styleAtom.getCharacterStyles();
            while (cStyles.size() > 1) {
                cStyles.removeLast();
            }
            this._rtRuns[0].setText(s);
        } else {
            this._rtRuns[0] = new RichTextRun(this, 0, s.length());
        }
    }

    public void setTextRuler(TextRulerAtom tra) {
        this._rulerAtom = tra;
    }

    public void supplySlideShow(SlideShow ss) {
        this.slideShow = ss;
        if (this._rtRuns != null) {
            for (int i = 0; i < this._rtRuns.length; ++i) {
                this._rtRuns[i].supplySlideShow(this.slideShow);
            }
        }
    }

    protected int getShapeId() {
        return this.shapeId;
    }

    protected void setShapeId(int id) {
        this.shapeId = id;
    }

    private String[] splitIntoParagraphs(String substring) {
        ArrayList<String> paraList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        for (int x = 0; x < substring.length(); ++x) {
            char ch = substring.charAt(x);
            buf.append(ch);
            if (ch != '\r' && ch != '\u000b') continue;
            paraList.add(buf.toString());
            buf = new StringBuffer();
        }
        if (buf.length() > 0) {
            paraList.add(buf.toString());
        }
        return paraList.toArray(new String[paraList.size()]);
    }

    private void storeText(String s) {
        if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        if (this._isUnicode) {
            this._charAtom.setText(s);
        } else {
            boolean hasMultibyte = StringUtil.hasMultibyte(s);
            if (!hasMultibyte) {
                byte[] text = new byte[s.length()];
                StringUtil.putCompressedUnicode(s, text, 0);
                this._byteAtom.setText(text);
            } else {
                this._charAtom = new TextCharsAtom();
                this._charAtom.setText(s);
                RecordContainer parent = this._headerAtom.getParentRecord();
                Record[] cr = parent.getChildRecords();
                for (int i = 0; i < cr.length; ++i) {
                    if (!cr[i].equals(this._byteAtom)) continue;
                    cr[i] = this._charAtom;
                    break;
                }
                this._byteAtom = null;
                this._isUnicode = true;
            }
        }
    }
}

