/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.model;

import com.benryan.escher.api.usermodel.Background;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.ppt.api.model.ISlide;
import com.benryan.ppt.api.model.MasterSheet;
import com.benryan.ppt.api.model.Notes;
import com.benryan.ppt.api.model.Sheet;
import com.benryan.ppt.api.model.SlideMaster;
import com.benryan.ppt.api.model.TextRun;
import com.benryan.ppt.api.model.TitleMaster;
import com.benryan.ppt.api.record.SlideAtom;
import com.benryan.ppt.api.record.SlideListWithText;
import java.util.Vector;

public class Slide
extends Sheet
implements ISlide {
    private int _slideNo;
    private SlideListWithText.SlideAtomsSet _atomSet;
    private TextRun[] _runs;
    private Notes _notes;

    public Slide(com.benryan.ppt.api.record.Slide slide, Notes notes, SlideListWithText.SlideAtomsSet atomSet, int slideIdentifier, int slideNumber) {
        super(slide, slideIdentifier);
        this._notes = notes;
        this._atomSet = atomSet;
        this._slideNo = slideNumber;
        TextRun[] _otherRuns = Slide.findTextRuns(this.getPPDrawing());
        Vector textRuns = new Vector();
        if (this._atomSet != null) {
            Slide.findTextRuns(this._atomSet.getSlideRecords(), textRuns, true);
        }
        this._runs = new TextRun[textRuns.size() + _otherRuns.length];
        int i = 0;
        for (i = 0; i < textRuns.size(); ++i) {
            this._runs[i] = (TextRun)textRuns.get(i);
            this._runs[i].setSheet(this);
        }
        for (int k = 0; k < _otherRuns.length; ++k) {
            this._runs[i] = _otherRuns[k];
            this._runs[i].setSheet(this);
            ++i;
        }
    }

    public Slide(int sheetNumber, int sheetRefId, int slideNumber) {
        super(new com.benryan.ppt.api.record.Slide(), sheetNumber);
        this._slideNo = slideNumber;
        this.getSheetContainer().setSheetId(sheetRefId);
    }

    public void setNotes(Notes notes) {
        this._notes = notes;
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        if (notes == null) {
            sa.setNotesID(0);
        } else {
            sa.setNotesID(notes._getSheetNumber());
        }
    }

    public void setSlideNumber(int newSlideNumber) {
        this._slideNo = newSlideNumber;
    }

    public String getTitle() {
        TextRun[] txt = this.getTextRuns();
        for (int i = 0; i < txt.length; ++i) {
            int type = txt[i].getRunType();
            if (type != 6 && type != 0) continue;
            String title = txt[i].getText();
            return title;
        }
        return null;
    }

    @Override
    public TextRun[] getTextRuns() {
        return this._runs;
    }

    public int getSlideNumber() {
        return this._slideNo;
    }

    public com.benryan.ppt.api.record.Slide getSlideRecord() {
        return (com.benryan.ppt.api.record.Slide)this.getSheetContainer();
    }

    public Notes getNotesSheet() {
        return this._notes;
    }

    protected SlideListWithText.SlideAtomsSet getSlideAtomsSet() {
        return this._atomSet;
    }

    @Override
    public MasterSheet getMasterSheet() {
        TitleMaster[] titleMaster;
        SlideMaster[] master = this.getSlideShow().getSlidesMasters();
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int masterId = sa.getMasterID();
        MasterSheet sheet = null;
        for (int i = 0; i < master.length; ++i) {
            if (masterId != master[i]._getSheetNumber()) continue;
            sheet = master[i];
            break;
        }
        if (sheet == null && (titleMaster = this.getSlideShow().getTitleMasters()) != null) {
            for (int i = 0; i < titleMaster.length; ++i) {
                if (masterId != titleMaster[i]._getSheetNumber()) continue;
                sheet = titleMaster[i];
                break;
            }
        }
        return sheet;
    }

    public Shape[] getMasterShapes() {
        return this.getMasterSheet().getShapes();
    }

    @Override
    public Background getMasterBackground() {
        return this.getMasterSheet().getBackground();
    }

    public void setMasterSheet(MasterSheet master) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int sheetNo = master._getSheetNumber();
        sa.setMasterID(sheetNo);
    }

    public void setFollowMasterBackground(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterBackground(flag);
    }

    @Override
    public boolean getFollowMasterBackground() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterBackground();
    }

    @Override
    public boolean getFollowMasterObjects() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterObjects();
    }

    @Override
    public boolean shouldShow() {
        return true;
    }
}

