/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.model;

import com.benryan.apache.poi.util.POILogFactory;
import com.benryan.apache.poi.util.POILogger;
import com.benryan.escher.api.EscherBSERecord;
import com.benryan.escher.api.EscherClientAnchorRecord;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherDgRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.usermodel.Background;
import com.benryan.escher.api.usermodel.Drawing;
import com.benryan.escher.api.usermodel.DrawingHost;
import com.benryan.escher.api.usermodel.HostEnvironment;
import com.benryan.escher.api.usermodel.Hyperlink;
import com.benryan.escher.api.usermodel.Picture;
import com.benryan.escher.api.usermodel.PictureData;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.escher.api.usermodel.TextBox;
import com.benryan.ppt.api.IPictureData;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.exceptions.HSLFException;
import com.benryan.ppt.api.model.EscherHostTextContainer;
import com.benryan.ppt.api.model.MasterSheet;
import com.benryan.ppt.api.model.TextRun;
import com.benryan.ppt.api.record.ColorSchemeAtom;
import com.benryan.ppt.api.record.Document;
import com.benryan.ppt.api.record.EscherTextboxWrapper;
import com.benryan.ppt.api.record.HeadersFooters;
import com.benryan.ppt.api.record.OEPlaceholderAtom;
import com.benryan.ppt.api.record.OutlineTextRefAtom;
import com.benryan.ppt.api.record.PPDrawing;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.SheetContainer;
import com.benryan.ppt.api.record.StyleTextPropAtom;
import com.benryan.ppt.api.record.TextBytesAtom;
import com.benryan.ppt.api.record.TextCharsAtom;
import com.benryan.ppt.api.record.TextHeaderAtom;
import com.benryan.ppt.api.usermodel.SlideShow;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class Sheet
implements DrawingHost,
HostEnvironment {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    private SlideShow _slideShow;
    private Background _background;
    private SheetContainer _container;
    private int _sheetNo;

    public Sheet(SheetContainer container, int sheetNo) {
        this._container = container;
        this._sheetNo = sheetNo;
    }

    public abstract TextRun[] getTextRuns();

    public int _getSheetRefId() {
        return this._container.getSheetId();
    }

    public int _getSheetNumber() {
        return this._sheetNo;
    }

    protected PPDrawing getPPDrawing() {
        return this._container.getPPDrawing();
    }

    public SlideShow getSlideShow() {
        return this._slideShow;
    }

    public SheetContainer getSheetContainer() {
        return this._container;
    }

    public void setSlideShow(SlideShow ss) {
        this._slideShow = ss;
        TextRun[] trs = this.getTextRuns();
        if (trs != null) {
            for (int i = 0; i < trs.length; ++i) {
                trs[i].supplySlideShow(this._slideShow);
            }
        }
    }

    public static TextRun[] findTextRuns(PPDrawing ppdrawing) {
        Vector runsV = new Vector();
        EscherTextboxWrapper[] wrappers = ppdrawing.getTextboxWrappers();
        for (int i = 0; i < wrappers.length; ++i) {
            int s1 = runsV.size();
            Sheet.findTextRuns(wrappers[i].getChildRecords(), runsV, false);
            int s2 = runsV.size();
            if (s2 == s1) continue;
            TextRun t = (TextRun)runsV.get(runsV.size() - 1);
            t.setShapeId(wrappers[i].getShapeId());
        }
        TextRun[] runs = new TextRun[runsV.size()];
        for (int i = 0; i < runs.length; ++i) {
            runs[i] = (TextRun)runsV.get(i);
        }
        return runs;
    }

    protected static void findTextRuns(Record[] records, Vector found, boolean fromSlideList) {
        int slwtIndex = 0;
        for (int i = 0; i < records.length - 1; ++i) {
            if (!(records[i] instanceof TextHeaderAtom)) continue;
            TextRun trun = null;
            TextHeaderAtom tha = (TextHeaderAtom)records[i];
            StyleTextPropAtom stpa = null;
            if (i < records.length - 2 && records[i + 2] instanceof StyleTextPropAtom) {
                stpa = (StyleTextPropAtom)records[i + 2];
            }
            if (records[i + 1] instanceof TextCharsAtom) {
                TextCharsAtom tca = (TextCharsAtom)records[i + 1];
                trun = new TextRun(tha, tca, stpa);
            } else if (records[i + 1] instanceof TextBytesAtom) {
                TextBytesAtom tba = (TextBytesAtom)records[i + 1];
                trun = new TextRun(tha, tba, stpa);
            } else if (records[i + 1].getRecordType() == 4001L || records[i + 1].getRecordType() == 4010L) {
                // empty if block
            }
            if (trun != null) {
                ArrayList<Record> lst = new ArrayList<Record>();
                for (int j = i; !(j >= records.length || j > i && records[j] instanceof TextHeaderAtom); ++j) {
                    lst.add(records[j]);
                }
                Record[] recs = new Record[lst.size()];
                lst.toArray(recs);
                trun._records = recs;
                if (fromSlideList) {
                    trun.setSlideIndex(slwtIndex);
                }
                found.add(trun);
                ++i;
            }
            ++slwtIndex;
        }
    }

    public Shape[] getShapes() {
        PPDrawing ppdrawing = this.getPPDrawing();
        EscherContainerRecord dg = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
        Drawing drawing = new Drawing(dg, this);
        return drawing.getShapes();
    }

    public void addShape(Shape shape) {
        PPDrawing ppdrawing = this.getPPDrawing();
        EscherContainerRecord dgContainer = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
        EscherContainerRecord spgr = (EscherContainerRecord)Shape.getEscherChild(dgContainer, -4093);
        spgr.addChildRecord(shape.getSpContainer());
        EscherDgRecord dg = (EscherDgRecord)Shape.getEscherChild(dgContainer, -4088);
        dg.setNumShapes(dg.getNumShapes() + 1);
        int shapeId = dg.getLastMSOSPID() + 1;
        dg.setLastMSOSPID(shapeId);
        EscherSpRecord sp = shape.getSpContainer().getChildById((short)-4086);
        if (sp != null) {
            sp.setShapeId(shapeId);
        }
        shape.setHostObject(this);
        shape.afterInsert(this);
        if (shape instanceof TextBox) {
            TextBox tbox = (TextBox)shape;
            ppdrawing.addTextboxWrapper((EscherTextboxWrapper)tbox.getHostSpecificProp("wrapper"));
        }
    }

    public abstract MasterSheet getMasterSheet();

    public ColorSchemeAtom getColorScheme() {
        if (this._container.doesSchemeFollowMaster()) {
            return this.getMasterSheet().getColorScheme();
        }
        return this._container.getColorScheme();
    }

    public Background getBackground() {
        if (this._background == null) {
            PPDrawing ppdrawing = this.getPPDrawing();
            EscherContainerRecord dg = (EscherContainerRecord)ppdrawing.getEscherRecords()[0];
            EscherContainerRecord spContainer = null;
            List<EscherRecord> ch = dg.getChildRecords();
            for (EscherRecord rec : ch) {
                if (rec.getRecordId() != -4092) continue;
                spContainer = (EscherContainerRecord)rec;
                break;
            }
            this._background = new Background(spContainer, null);
            this._background.setHostObject(this);
        }
        return this._background;
    }

    @Override
    public HostEnvironment getEnvironment() {
        return this;
    }

    @Override
    public void initShape(IShape shape) {
        if (shape instanceof TextBox) {
            this.initTextRun((TextBox)shape);
        }
    }

    private void initTextRun(TextBox textbox) {
        EscherTextboxWrapper txtbox = new EscherTextboxWrapper(textbox.getEscherRecord());
        textbox.setHostSpecificProp("wrapper", txtbox);
        OutlineTextRefAtom ota = null;
        Record[] child = txtbox.getChildRecords();
        for (int i = 0; i < child.length; ++i) {
            if (!(child[i] instanceof OutlineTextRefAtom)) continue;
            ota = (OutlineTextRefAtom)child[i];
            break;
        }
        TextRun[] runs = this.getTextRuns();
        TextRun boxRun = null;
        if (ota != null) {
            int idx = ota.getTextIndex();
            for (int x = 0; x < runs.length; ++x) {
                if (runs[x].getSlideIndex() != idx) continue;
                boxRun = runs[x];
                break;
            }
            if (boxRun == null) {
                this.logger.log(5, "text run not found for OutlineTextRefAtom.TextIndex=" + idx);
            }
        } else {
            int shapeId = textbox.getEscherContainer().getChildById((short)-4086).getShapeId();
            if (runs != null) {
                for (int i = 0; i < runs.length; ++i) {
                    if (runs[i].getShapeId() != shapeId) continue;
                    boxRun = runs[i];
                    break;
                }
            }
            if (boxRun == null) {
                this.logger.log(5, "text run not found for shapeId=" + shapeId);
            }
        }
        if (boxRun != null) {
            textbox.setHostSpecificProp("run", boxRun);
            boxRun.setSheet(this);
            boxRun.setTextRuler(txtbox.getTextRuler());
        }
    }

    @Override
    public void afterInsert(IShape sh, DrawingHost hostObj) {
        Rectangle2D anchor;
        Sheet sheet = (Sheet)hostObj;
        if (sh instanceof TextBox) {
            TextBox tb = (TextBox)sh;
            EscherTextboxWrapper wrapper = new EscherTextboxWrapper(tb.getEscherRecord());
            PPDrawing ppdrawing = sheet.getPPDrawing();
            ppdrawing.addTextboxWrapper(wrapper);
            try {
                wrapper.writeOut(null);
            }
            catch (IOException e) {
                throw new HSLFException(e);
            }
        } else if (sh instanceof Picture && (anchor = sh.getAnchor()).equals(new Rectangle())) {
            ((Picture)sh).setDefaultSize();
        }
    }

    @Override
    public Shape findMasterShape(int masterID) {
        MasterSheet master = this.getMasterSheet();
        Shape[] shapes = master.getShapes();
        for (int x = 0; x < shapes.length; ++x) {
            if (shapes[x].getShapeId() != masterID) continue;
            return shapes[x];
        }
        return null;
    }

    @Override
    public EscherContainerRecord getDggContainer() {
        SlideShow ppt = this.getSlideShow();
        Document doc = ppt.getDocumentRecord();
        return doc.getPPDrawingGroup().getDggContainer();
    }

    @Override
    public Color getHostColor(int rgb) {
        if (rgb >= 0x8000000) {
            int idx = rgb - 0x8000000;
            ColorSchemeAtom ca = this.getColorScheme();
            if (idx >= 0 && idx <= 7) {
                rgb = ca.getColor(idx);
            }
        }
        Color tmp = new Color(rgb, true);
        return new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
    }

    @Override
    public Hyperlink getHyperlink(IShape sh) {
        return null;
    }

    @Override
    public IPictureData getImage(EscherBSERecord bse) {
        SlideShow ppt = this.getSlideShow();
        PictureData[] pict = ppt.getPictureData();
        for (int i = 0; i < pict.length; ++i) {
            if (pict[i].getOffset() != bse.getOffset()) continue;
            return pict[i];
        }
        return null;
    }

    @Override
    public EscherHostTextContainer getTextContainer(Shape shape) {
        TextRun run = (TextRun)shape.getHostSpecificProp("run");
        return run;
    }

    public HeadersFooters getHeadersFooters() {
        SlideShow ppt = this.getSlideShow();
        Document doc = ppt.getDocumentRecord();
        return doc.getHeadersFooters();
    }

    @Override
    public Rectangle getAnchor(IShape shape, EscherRecord clientAnchor) {
        EscherClientAnchorRecord rec = (EscherClientAnchorRecord)clientAnchor;
        Rectangle anchor = new Rectangle();
        anchor.y = rec.getFlag() * 96 / 576;
        anchor.x = rec.getCol1() * 96 / 576;
        anchor.width = (rec.getDx1() - rec.getCol1()) * 96 / 576;
        anchor.height = (rec.getRow1() - rec.getFlag()) * 96 / 576;
        return anchor;
    }

    @Override
    public boolean shouldRenderText(TextBox txtBox, boolean isMaster) {
        if (!isMaster) {
            return true;
        }
        OEPlaceholderAtom placeHolder = txtBox.getPlaceHolderInfo();
        if (placeHolder == null) {
            return true;
        }
        HeadersFooters hdrsFtrs = this.getHeadersFooters();
        switch (placeHolder.getPlaceholderId()) {
            case 9: {
                return hdrsFtrs != null && hdrsFtrs.displayFooter();
            }
            case 10: {
                return hdrsFtrs != null && hdrsFtrs.displayHeader();
            }
        }
        return false;
    }
}

