/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.model;

import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.ppt.api.model.Sheet;
import com.benryan.ppt.api.model.TextRun;
import com.benryan.ppt.api.record.ExHyperlink;
import com.benryan.ppt.api.record.ExObjList;
import com.benryan.ppt.api.record.InteractiveInfo;
import com.benryan.ppt.api.record.InteractiveInfoAtom;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.TxInteractiveInfoAtom;
import com.benryan.ppt.api.usermodel.SlideShow;
import java.util.ArrayList;
import java.util.List;

public class Hyperlink {
    private int type;
    private String address;
    private String title;
    private int startIndex;
    private int endIndex;

    public int getType() {
        return this.type;
    }

    public String getAddress() {
        return this.address;
    }

    public String getTitle() {
        return this.title;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    protected static Hyperlink[] find(TextRun run) {
        ArrayList<Hyperlink> lst = new ArrayList<Hyperlink>();
        SlideShow ppt = run.getSheet().getSlideShow();
        ExObjList exobj = ppt.getDocumentRecord().getExObjList();
        if (exobj == null) {
            return null;
        }
        Record[] records = run._records;
        if (records != null) {
            Hyperlink.find(records, exobj, lst);
        }
        Hyperlink[] links = null;
        if (lst.size() > 0) {
            links = new Hyperlink[lst.size()];
            lst.toArray(links);
        }
        return links;
    }

    protected static Hyperlink find(Shape shape) {
        ArrayList<Hyperlink> lst = new ArrayList<Hyperlink>();
        SlideShow ppt = ((Sheet)shape.getHostObject()).getSlideShow();
        ExObjList exobj = ppt.getDocumentRecord().getExObjList();
        if (exobj == null) {
            return null;
        }
        EscherContainerRecord spContainer = shape.getSpContainer();
        List<EscherRecord> spchild = spContainer.getChildRecords();
        for (EscherRecord obj : spchild) {
            byte[] data;
            Record[] records;
            if (obj.getRecordId() != -4079 || (records = Record.findChildRecords(data = obj.serialize(), 8, data.length - 8)) == null) continue;
            Hyperlink.find(records, exobj, lst);
        }
        return lst.size() == 1 ? (Hyperlink)lst.get(0) : null;
    }

    private static void find(Record[] records, ExObjList exobj, List<Hyperlink> out) {
        for (int i = 0; i < records.length; ++i) {
            InteractiveInfo hldr;
            InteractiveInfoAtom info;
            int id;
            ExHyperlink linkRecord;
            if (!(records[i] instanceof InteractiveInfo) || (linkRecord = exobj.get(id = (info = (hldr = (InteractiveInfo)records[i]).getInteractiveInfoAtom()).getHyperlinkID())) == null) continue;
            Hyperlink link = new Hyperlink();
            link.title = linkRecord.getLinkTitle();
            link.address = linkRecord.getLinkURL();
            link.type = info.getAction();
            if (++i < records.length && records[i] instanceof TxInteractiveInfoAtom) {
                TxInteractiveInfoAtom txinfo = (TxInteractiveInfoAtom)records[i];
                link.startIndex = txinfo.getStartIndex();
                link.endIndex = txinfo.getEndIndex();
            }
            out.add(link);
        }
    }
}

