/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.blip;

import com.benryan.ppt.api.blip.Metafile;
import com.benryan.ppt.api.exceptions.HSLFException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class PICT
extends Metafile {
    @Override
    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        try {
            byte[] pict;
            byte[] macheader = new byte[512];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(macheader);
            int pos = 16;
            try {
                pict = this.read(rawdata, pos);
            }
            catch (IOException e) {
                pict = this.read(rawdata, pos + 16);
            }
            out.write(pict);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    private byte[] read(byte[] data, int pos) throws IOException {
        int count;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Metafile.Header header = new Metafile.Header();
        header.read(data, pos);
        bis.skip(pos + header.getSize());
        InflaterInputStream inflater = new InflaterInputStream(bis);
        byte[] chunk = new byte[4096];
        while ((count = inflater.read(chunk)) >= 0) {
            out.write(chunk, 0, count);
        }
        inflater.close();
        return out.toByteArray();
    }

    @Override
    public void setData(byte[] data) throws IOException {
        int pos = 512;
        byte[] compressed = this.compress(data, pos, data.length - pos);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length - 512;
        header.bounds = new Rectangle(0, 0, 200, 200);
        header.size = new Dimension(header.bounds.width * 9525, header.bounds.height * 9525);
        header.zipsize = compressed.length;
        byte[] checksum = PICT.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        out.write(new byte[16]);
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getSignature() {
        return 21552;
    }
}

