/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api.blip;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.blip.Bitmap;
import java.io.IOException;

public class DIB
extends Bitmap {
    public static final int HEADER_SIZE = 14;

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public int getSignature() {
        return 31360;
    }

    @Override
    public byte[] getData() {
        byte[] data = super.getData();
        byte[] header = new byte[14];
        LittleEndian.putInt(header, 0, 19778);
        LittleEndian.putInt(header, 2, data.length);
        LittleEndian.putInt(header, 6, 0);
        LittleEndian.putInt(header, 10, 2);
        byte[] dib = new byte[header.length + data.length];
        System.arraycopy(header, 0, dib, 0, header.length);
        System.arraycopy(data, 0, dib, header.length, data.length);
        return dib;
    }

    @Override
    public void setData(byte[] data) throws IOException {
        byte[] dib = new byte[data.length - 14];
        System.arraycopy(data, 14, dib, 0, dib.length);
        super.setData(dib);
    }
}

