/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.apache.poi.util.POILogFactory;
import com.benryan.apache.poi.util.POILogger;
import com.benryan.escher.api.usermodel.PictureData;
import com.benryan.ppt.api.EncryptedSlideShow;
import com.benryan.ppt.api.exceptions.CorruptPowerPointFileException;
import com.benryan.ppt.api.exceptions.EncryptedPowerPointFileException;
import com.benryan.ppt.api.exceptions.HSLFException;
import com.benryan.ppt.api.record.CurrentUserAtom;
import com.benryan.ppt.api.record.PersistPtrHolder;
import com.benryan.ppt.api.record.PositionDependentRecord;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.UserEditAtom;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSLFSlideShow {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    private InputStream istream;
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Record[] _records;
    private PictureData[] _pictures;
    POIFSFileSystem filesystem;

    protected POIFSFileSystem getPOIFSFileSystem() {
        return this.filesystem;
    }

    public HSLFSlideShow(String fileName) throws IOException {
        this(new FileInputStream(fileName));
    }

    public HSLFSlideShow(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
        this.istream = inputStream;
    }

    public HSLFSlideShow(POIFSFileSystem filesystem) throws IOException {
        this.filesystem = filesystem;
        this.readCurrentUserStream();
        this.readPowerPointStream();
        boolean encrypted = EncryptedSlideShow.checkIfEncrypted(this);
        if (encrypted) {
            throw new EncryptedPowerPointFileException("Encrypted PowerPoint files are not supported");
        }
        this.buildRecords();
        this.readOtherStreams();
        this.readPictures();
    }

    public HSLFSlideShow() throws IOException {
        this(HSLFSlideShow.class.getResourceAsStream("/org/apache/poi/hslf/data/empty.ppt"));
    }

    public void close() throws IOException {
        if (this.istream != null) {
            this.istream.close();
        }
        this.filesystem = null;
    }

    private void readPowerPointStream() throws IOException {
        DocumentEntry docProps = (DocumentEntry)this.filesystem.getRoot().getEntry("PowerPoint Document");
        this._docstream = new byte[docProps.getSize()];
        this.filesystem.createDocumentInputStream("PowerPoint Document").read(this._docstream);
    }

    private void buildRecords() {
        this._records = this.read(this._docstream, (int)this.currentUser.getCurrentEditOffset());
    }

    private Record[] read(byte[] docstream, int usrOffset) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        while (usrOffset != 0) {
            UserEditAtom usr = (UserEditAtom)Record.buildRecordAtOffset(docstream, usrOffset);
            lst.add(usrOffset);
            int psrOffset = usr.getPersistPointersOffset();
            PersistPtrHolder ptr = (PersistPtrHolder)Record.buildRecordAtOffset(docstream, psrOffset);
            lst.add(psrOffset);
            Hashtable<Integer, Integer> entries = ptr.getSlideLocationsLookup();
            for (Integer id : entries.keySet()) {
                Integer offset = entries.get(id);
                lst.add(offset);
            }
            usrOffset = usr.getLastUserEditAtomOffset();
        }
        Object[] a = lst.toArray();
        Arrays.sort(a);
        Record[] rec = new Record[lst.size()];
        for (int i = 0; i < a.length; ++i) {
            Integer offset = (Integer)a[i];
            rec[i] = Record.buildRecordAtOffset(docstream, offset);
        }
        return rec;
    }

    private void readCurrentUserStream() {
        try {
            this.currentUser = new CurrentUserAtom(this.filesystem);
        }
        catch (IOException ie) {
            this.logger.log(7, "Error finding Current User Atom:\n" + ie);
            this.currentUser = new CurrentUserAtom();
        }
    }

    private void readOtherStreams() {
    }

    private void readPictures() throws IOException {
        byte[] pictstream;
        try {
            DocumentEntry entry = (DocumentEntry)this.filesystem.getRoot().getEntry("Pictures");
            pictstream = new byte[entry.getSize()];
            DocumentInputStream is = this.filesystem.createDocumentInputStream("Pictures");
            is.read(pictstream);
        }
        catch (FileNotFoundException e) {
            return;
        }
        List<PictureData> p = this.readPictures(pictstream);
        this._pictures = p.toArray(new PictureData[p.size()]);
    }

    private List<PictureData> readPictures(byte[] data) {
        int imageSizeInBytes;
        int contentSize = data.length - 8;
        ArrayList<PictureData> pictures = new ArrayList<PictureData>();
        for (int pos = 0; pos <= contentSize; pos += imageSizeInBytes) {
            int offset = pos;
            int type = LittleEndian.getUShort(data, pos += 2);
            imageSizeInBytes = LittleEndian.getInt(data, pos += 2);
            this.readPicture(data, pictures, pos += 4, offset, type, imageSizeInBytes);
        }
        return pictures;
    }

    private void readPicture(byte[] data, List<PictureData> pictures, int pos, int offset, int type, int imageSizeInBytes) {
        HSLFSlideShow.assertValidImageSize(imageSizeInBytes, pictures.size());
        if (type == 0) {
            this.logger.log(7, "Problem reading picture: Invalid image type 0, on picture with length " + imageSizeInBytes + ".\nYou document will probably become corrupted if you save it!");
            this.logger.log(7, "" + pos);
        } else {
            byte[] imgdata = HSLFSlideShow.getImageData(data, pos, imageSizeInBytes);
            try {
                pictures.add(HSLFSlideShow.createPicture(offset, type, imgdata));
            }
            catch (IllegalArgumentException e) {
                this.logger.log(7, "Problem reading picture: " + e + "\nYou document will probably become corrupted if you save it!");
            }
        }
    }

    private static PictureData createPicture(int offset, int type, byte[] imgdata) {
        PictureData pict = PictureData.create(type - 61464);
        pict.setRawData(imgdata);
        pict.setOffset(offset);
        return pict;
    }

    private static byte[] getImageData(byte[] pictstream, int pos, int imageSizeInBytes) {
        byte[] imgdata = new byte[imageSizeInBytes];
        if (imageSizeInBytes > 0) {
            System.arraycopy(pictstream, pos, imgdata, 0, imgdata.length);
        }
        return imgdata;
    }

    private static void assertValidImageSize(int imgsize, int position) {
        if (imgsize < 0) {
            throw new CorruptPowerPointFileException("The file contains a picture, at position " + position + ", which has a negatively sized data length, so we can't trust any of the picture data");
        }
    }

    public void write(OutputStream out) throws IOException {
        PositionDependentRecord pdr;
        POIFSFileSystem outFS = new POIFSFileSystem();
        Hashtable<Integer, Integer> oldToNewPositions = new Hashtable<Integer, Integer>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Record _record : this._records) {
            if (_record instanceof PositionDependentRecord) {
                pdr = (PositionDependentRecord)((Object)_record);
                int oldPos = pdr.getLastOnDiskOffset();
                int newPos = baos.size();
                pdr.setLastOnDiskOffset(newPos);
                oldToNewPositions.put(oldPos, newPos);
            }
            _record.writeOut(baos);
        }
        baos.reset();
        for (Record _record : this._records) {
            if (_record instanceof PositionDependentRecord) {
                pdr = (PositionDependentRecord)((Object)_record);
                pdr.updateOtherRecordReferences(oldToNewPositions);
            }
            _record.writeOut(baos);
        }
        this._docstream = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        outFS.createDocument((InputStream)bais, "PowerPoint Document");
        int oldLastUserEditAtomPos = (int)this.currentUser.getCurrentEditOffset();
        Integer newLastUserEditAtomPos = (Integer)oldToNewPositions.get(new Integer(oldLastUserEditAtomPos));
        if (newLastUserEditAtomPos == null) {
            throw new HSLFException("Couldn't find the new location of the UserEditAtom that used to be at " + oldLastUserEditAtomPos);
        }
        this.currentUser.setCurrentEditOffset(newLastUserEditAtomPos.intValue());
        this.currentUser.writeToFS(outFS);
        if (this._pictures != null) {
            ByteArrayOutputStream pict = new ByteArrayOutputStream();
            for (PictureData _picture : this._pictures) {
                _picture.write(pict);
            }
            outFS.createDocument((InputStream)new ByteArrayInputStream(pict.toByteArray()), "Pictures");
        }
        outFS.writeFilesystem(out);
    }

    public synchronized int appendRootLevelRecord(Record newRecord) {
        int addedAt = -1;
        Record[] r = new Record[this._records.length + 1];
        boolean added = false;
        for (int i = this._records.length - 1; i >= 0; --i) {
            if (added) {
                r[i] = this._records[i];
                continue;
            }
            r[i + 1] = this._records[i];
            if (!(this._records[i] instanceof PersistPtrHolder)) continue;
            r[i] = newRecord;
            added = true;
            addedAt = i;
        }
        this._records = r;
        return addedAt;
    }

    public void addPicture(PictureData img) {
        PictureData[] lst;
        if (this._pictures == null) {
            lst = new PictureData[1];
        } else {
            lst = new PictureData[this._pictures.length + 1];
            System.arraycopy(this._pictures, 0, lst, 0, this._pictures.length);
        }
        lst[lst.length - 1] = img;
        this._pictures = lst;
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }

    public PictureData[] getPictures() {
        return this._pictures;
    }
}

