/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt.api;

import com.benryan.ppt.api.HSLFSlideShow;
import com.benryan.ppt.api.exceptions.CorruptPowerPointFileException;
import com.benryan.ppt.api.record.CurrentUserAtom;
import com.benryan.ppt.api.record.DocumentEncryptionAtom;
import com.benryan.ppt.api.record.PersistPtrHolder;
import com.benryan.ppt.api.record.Record;
import com.benryan.ppt.api.record.UserEditAtom;
import java.io.FileNotFoundException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EncryptedSlideShow {
    public static boolean checkIfEncrypted(HSLFSlideShow hss) {
        POIFSFileSystem fs = hss.getPOIFSFileSystem();
        try {
            fs.getRoot().getEntry("EncryptedSummary");
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            DocumentEncryptionAtom dea = EncryptedSlideShow.fetchDocumentEncryptionAtom(hss);
            return dea != null;
        }
    }

    public static DocumentEncryptionAtom fetchDocumentEncryptionAtom(HSLFSlideShow hss) {
        CurrentUserAtom cua = hss.getCurrentUserAtom();
        if (cua.getCurrentEditOffset() != 0L) {
            if (cua.getCurrentEditOffset() > (long)hss.getUnderlyingBytes().length) {
                throw new CorruptPowerPointFileException("The CurrentUserAtom claims that the offset of last edit details are past the end of the file");
            }
            Record r = null;
            try {
                r = Record.buildRecordAtOffset(hss.getUnderlyingBytes(), (int)cua.getCurrentEditOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (r == null) {
                return null;
            }
            if (!(r instanceof UserEditAtom)) {
                return null;
            }
            UserEditAtom uea = (UserEditAtom)r;
            Record r2 = Record.buildRecordAtOffset(hss.getUnderlyingBytes(), uea.getPersistPointersOffset());
            if (!(r2 instanceof PersistPtrHolder)) {
                return null;
            }
            PersistPtrHolder pph = (PersistPtrHolder)r2;
            int[] slideIds = pph.getKnownSlideIDs();
            int maxSlideId = -1;
            for (int i = 0; i < slideIds.length; ++i) {
                if (slideIds[i] <= maxSlideId) continue;
                maxSlideId = slideIds[i];
            }
            if (maxSlideId == -1) {
                return null;
            }
            int offset = pph.getSlideLocationsLookup().get(new Integer(maxSlideId));
            Record r3 = Record.buildRecordAtOffset(hss.getUnderlyingBytes(), offset);
            if (r3 instanceof DocumentEncryptionAtom) {
                return (DocumentEncryptionAtom)r3;
            }
        }
        return null;
    }
}

