/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt;

import com.benryan.escher.EscherRenderer;
import com.benryan.ppt.SlideImageSerializer;
import com.benryan.ppt.api.HSLFSlideShow;
import com.benryan.ppt.api.IBackground;
import com.benryan.ppt.api.IPicture;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.model.ISlide;
import com.benryan.ppt.api.usermodel.ISlideShow;
import com.benryan.ppt.api.usermodel.SlideShow;
import com.benryan.pptx.XMLSlideShow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public abstract class PptRenderer
implements SlideImageSerializer {
    private Paint defaultFill;
    private SlideImageSerializer imageSerializer;
    private final ISlideShow slideShow;
    public static double POINTS_TO_PIXELS = 1.3333333333333333;

    public PptRenderer(InputStream in, boolean isXml) throws IOException {
        this.slideShow = isXml ? this.getNewXmlSlideShow(in) : this.getNewSlideShow(in);
    }

    protected ISlideShow getNewXmlSlideShow(InputStream in) {
        try {
            return XMLSlideShow.createSlideshow(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ISlideShow getNewSlideShow(InputStream in) throws IOException {
        return new SlideShow(new HSLFSlideShow(in));
    }

    public void render(int startAt, int length, Map<RenderingHints.Key, Object> hints) throws IOException {
        EscherRenderer renderer = new EscherRenderer();
        Dimension pageSize = this.slideShow.getPageSize();
        int slideCount = this.slideShow.getSlideCount();
        if (length == 0) {
            length = slideCount;
        }
        length = Math.min(length, slideCount);
        int i = startAt;
        for (int index = 0; index < length; ++index) {
            ISlide slide = this.slideShow.getSlide(i);
            double imgWidth = pageSize.width;
            double imgHeight = pageSize.height;
            Graphics2D g = this.createAndInitSlideGraphics(i, imgWidth, imgHeight);
            if (hints != null) {
                g.addRenderingHints(hints);
            }
            IBackground b = null;
            b = slide.getFollowMasterBackground() ? slide.getMasterBackground() : slide.getBackground();
            if (b == null) {
                this.defaultFill = Color.white;
                g.setPaint(this.defaultFill);
                g.fillRect(0, 0, pageSize.width, pageSize.height);
            } else if (b.isPicture() || b.isTexture()) {
                IPicture pic = b.getBackgroundPicture();
                Rectangle fillRec = b.getFillRectangle(new Rectangle(pageSize));
                renderer.renderImage(g, fillRec, pic, null, b.isTexture());
            } else {
                this.defaultFill = b.getFillColor();
                g.setPaint(this.defaultFill);
                g.fillRect(0, 0, pageSize.width, pageSize.height);
            }
            IShape[] masterShapes = slide.getMasterShapes();
            IShape[] sh = slide.getShapes();
            if (slide.getFollowMasterObjects()) {
                renderer.walkShapes(g, masterShapes, null, null, true);
            }
            renderer.walkShapes(g, sh, null, null, false);
            this.endSlide(g, i);
            i = (i + 1) % slideCount;
        }
    }

    protected abstract void endSlide(Graphics2D var1, int var2) throws IOException;

    protected abstract Graphics2D createAndInitSlideGraphics(int var1, double var2, double var4) throws IOException;

    public void setSerializer(SlideImageSerializer serializer) {
        this.imageSerializer = serializer;
    }

    protected void doSerialization(byte[] buf, int i) throws IOException {
        if (this.imageSerializer == null) {
            this.serializeSlideImage(buf, i);
        } else {
            this.imageSerializer.serializeSlideImage(buf, i);
        }
    }

    public int getNumSlides() {
        return this.slideShow.getSlideCount();
    }

    public void close() {
        this.slideShow.close();
    }
}

