/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.ppt;

import com.benryan.escher.api.usermodel.ITextBox;
import com.benryan.fonts.FontManager;
import com.benryan.ppt.PptRenderer;
import com.benryan.ppt.api.usermodel.IParagraph;
import com.benryan.ppt.api.usermodel.IParagraphStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class ParagraphLayout {
    TextLayout _bullet;
    ArrayList _layouts;
    IParagraphStyle paragraphStyle;
    boolean _softBreak;

    public ParagraphLayout(IParagraphStyle firstRun) {
        this.paragraphStyle = firstRun;
        this._layouts = this.getNewArrayList();
    }

    protected ArrayList getNewArrayList() {
        return new ArrayList();
    }

    public Color getBulletColor() {
        return this.paragraphStyle.getBulletColor();
    }

    public int getBulletIndent() {
        int firstLine = this.paragraphStyle.getBulletOffset();
        int indent = this.paragraphStyle.getTextOffset();
        return Math.min(firstLine, indent);
    }

    public TextLayout getBulletLayout() {
        return this._bullet;
    }

    public int getFirstLineIndent() {
        int firstLine = this.paragraphStyle.getBulletOffset();
        int indent = this.paragraphStyle.getTextOffset();
        if (this._bullet != null) {
            return Math.max(firstLine, indent);
        }
        return firstLine;
    }

    public int getIndent() {
        return this.paragraphStyle.getTextOffset();
    }

    public ArrayList getLayouts() {
        return this._layouts;
    }

    public double getLineHeight(int index) {
        double lineSpacing = this.paragraphStyle.getLineSpacing();
        if (lineSpacing < 0.0) {
            lineSpacing = 0.0 - lineSpacing;
            return lineSpacing;
        }
        double multiplier = lineSpacing / 100.0;
        TextLayout lineLayout = (TextLayout)this._layouts.get(index);
        double paragraphHeight = (double)(lineLayout.getAscent() + lineLayout.getDescent()) * multiplier;
        return paragraphHeight;
    }

    public int getParagraphAlignment() {
        return this.paragraphStyle.getAlignment();
    }

    public double getParagraphHeight() {
        double lineSpacing = this.paragraphStyle.getLineSpacing();
        if (lineSpacing < 0.0) {
            lineSpacing = 0.0 - lineSpacing;
            return lineSpacing * (double)this._layouts.size();
        }
        double multiplier = lineSpacing / 100.0;
        double paragraphHeight = 0.0;
        for (int x = 0; x < this._layouts.size(); ++x) {
            TextLayout lineLayout = (TextLayout)this._layouts.get(x);
            paragraphHeight += (double)(lineLayout.getAscent() + lineLayout.getDescent()) * multiplier;
        }
        return paragraphHeight;
    }

    public double getSpaceAfter() {
        double spaceAfter = this.paragraphStyle.getSpaceAfter();
        if (spaceAfter < 0.0) {
            spaceAfter = 0.0 - spaceAfter;
            return spaceAfter;
        }
        double multiplier = spaceAfter / 100.0;
        TextLayout layout = (TextLayout)this._layouts.get(this._layouts.size() - 1);
        double height = layout.getAscent() + layout.getDescent();
        return height * multiplier;
    }

    public double getSpaceBefore() {
        double spaceBefore = this.paragraphStyle.getSpaceBefore();
        if (spaceBefore < 0.0) {
            spaceBefore = 0.0 - spaceBefore;
            return spaceBefore;
        }
        double multiplier = spaceBefore / 100.0;
        TextLayout layout = (TextLayout)this._layouts.get(0);
        double height = layout.getAscent() + layout.getDescent();
        return height * multiplier;
    }

    public Color getTextColor() {
        Color c = this.paragraphStyle.getFontColor();
        return c;
    }

    public boolean isSoftBreak() {
        return this._softBreak;
    }

    public void layoutParagraph(Graphics2D g, ITextBox shape, Rectangle2D anchor, IParagraph paragraph) {
        TextLayout bulletLayout = null;
        this._softBreak = paragraph.isSoftBreak();
        if (this.paragraphStyle.isBullet()) {
            Font bulletFont;
            char bullet = this.paragraphStyle.getBulletChar();
            double bulletSize = this.paragraphStyle.getBulletSize();
            double points = (double)this.paragraphStyle.getFontSize() * PptRenderer.POINTS_TO_PIXELS;
            if (bulletSize >= 0.0) {
                double multiplier = bulletSize / 100.0;
                points = multiplier * points;
            } else {
                points = 0.0 - bulletSize;
            }
            String fontName = this.paragraphStyle.getBulletFontName();
            if (fontName == null) {
                fontName = this.paragraphStyle.getFontName();
            }
            if (!(bulletFont = this.getBulletFont(points, fontName)).canDisplay(bullet) && (fontName.startsWith("Wingdings") || fontName.startsWith("Webdings") || fontName.equals("Symbol"))) {
                bullet = (bullet & 0xF000) == 61440 ? (char)(bullet & 0xFF) : (char)(bullet | 0xF000);
            }
            bulletLayout = new TextLayout(String.valueOf(bullet), bulletFont, g.getFontRenderContext());
            this.addBullet(bulletLayout);
        }
        LineBreakMeasurer measurer = new LineBreakMeasurer(paragraph.getIterator(), g.getFontRenderContext());
        double workingWidth = anchor.getWidth();
        int wordWrap = shape.getWordWrap();
        if (wordWrap == 2) {
            workingWidth = Double.MAX_VALUE;
        }
        double bulletWidth = bulletLayout != null ? (double)bulletLayout.getAdvance() : 0.0;
        double firstLineWidth = workingWidth -= (double)(shape.getMarginLeft() + shape.getMarginRight());
        firstLineWidth = this.getBulletIndent() == this.getFirstLineIndent() ? workingWidth - bulletWidth : workingWidth - (double)this.getFirstLineIndent();
        TextLayout line = measurer.nextLayout((float)Math.max(0.0, firstLineWidth));
        double indent = this.getIndent();
        while (line != null) {
            this.addLayout(line);
            line = measurer.nextLayout((float)Math.max(0.0, workingWidth - indent));
        }
        if (this._layouts.size() == 1 && ((TextLayout)this._layouts.get(0)).getAdvance() == 0.0f) {
            this._bullet = null;
        }
    }

    protected Font getBulletFont(double points, String fontName) {
        return FontManager.resolveFont((String)fontName, (int)0, (int)((int)points));
    }

    private void addBullet(TextLayout bullet) {
        this._bullet = bullet;
    }

    private void addLayout(TextLayout layout) {
        this._layouts.add(layout);
    }
}

