/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.AbstractTranscoder;
import com.benryan.graphics.emf.Arc;
import com.benryan.graphics.emf.BitBlt;
import com.benryan.graphics.emf.CreateBrushIndirect;
import com.benryan.graphics.emf.CreateFontIndirect;
import com.benryan.graphics.emf.CreatePatternBrush;
import com.benryan.graphics.emf.CreatePen;
import com.benryan.graphics.emf.DeleteObject;
import com.benryan.graphics.emf.Ellipse;
import com.benryan.graphics.emf.ExtTextOut;
import com.benryan.graphics.emf.Header;
import com.benryan.graphics.emf.IRenderableObject;
import com.benryan.graphics.emf.IWmf2SvgConverter;
import com.benryan.graphics.emf.IntersectClipRect;
import com.benryan.graphics.emf.LineTo;
import com.benryan.graphics.emf.MoveTo;
import com.benryan.graphics.emf.Noop;
import com.benryan.graphics.emf.PolyBezier;
import com.benryan.graphics.emf.PolyPolygon;
import com.benryan.graphics.emf.Polygon;
import com.benryan.graphics.emf.Polyline;
import com.benryan.graphics.emf.Record;
import com.benryan.graphics.emf.Rectangle;
import com.benryan.graphics.emf.RestoreDC;
import com.benryan.graphics.emf.RoundRect;
import com.benryan.graphics.emf.SaveDC;
import com.benryan.graphics.emf.SelectClipRgn;
import com.benryan.graphics.emf.SelectObject;
import com.benryan.graphics.emf.SetBkColor;
import com.benryan.graphics.emf.SetBkMode;
import com.benryan.graphics.emf.SetMapMode;
import com.benryan.graphics.emf.SetPolyFillMode;
import com.benryan.graphics.emf.SetROP2;
import com.benryan.graphics.emf.SetStretchBltMode;
import com.benryan.graphics.emf.SetTextAlign;
import com.benryan.graphics.emf.SetTextColor;
import com.benryan.graphics.emf.SetViewportExtent;
import com.benryan.graphics.emf.SetViewportOrg;
import com.benryan.graphics.emf.SetWindowExtent;
import com.benryan.graphics.emf.SetWindowOrg;
import com.benryan.graphics.emf.StretchBlt;
import com.benryan.graphics.emf.StretchDIBits;
import com.benryan.graphics.emf.TranscoderException;
import com.benryan.graphics.emf.WMFRecord;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.IOException;

public class WMFTranscoder
extends AbstractTranscoder {
    protected static final int APM_HEADER_SIGNATURE = -1698247209;
    protected static final int APM_HEADER_SIZE = 22;
    protected static final int WMF_HEADER_SIZE = 18;
    protected static final int WMF_FAKE_HEADER = 65535;
    protected static final int WMF_ANIMATEPALETTE = 1078;
    protected static final int WMF_ARC = 2071;
    protected static final int WMF_BITBLT = 2338;
    protected static final int WMF_CHORD = 2096;
    protected static final int WMF_CREATEBRUSHINDIRECT = 764;
    protected static final int WMF_CREATEFONTINDIRECT = 763;
    protected static final int WMF_CREATEPALETTE = 247;
    protected static final int WMF_CREATEPATTERNBRUSH = 505;
    protected static final int WMF_CREATEPENINDIRECT = 762;
    protected static final int WMF_CREATEREGION = 1791;
    protected static final int WMF_DELETEOBJECT = 496;
    protected static final int WMF_DIBBITBLT = 2368;
    protected static final int WMF_DIBCREATEPATTERNBRUSH = 322;
    protected static final int WMF_DIBSTRETCHBLT = 2881;
    protected static final int WMF_DRAWTEXT = 1583;
    protected static final int WMF_ELLIPSE = 1048;
    protected static final int WMF_ESCAPE = 1574;
    protected static final int WMF_EXCLUDECLIPRECT = 1045;
    protected static final int WMF_EXTFLOODFILL = 1352;
    protected static final int WMF_EXTTEXTOUT = 2610;
    protected static final int WMF_FILLREGION = 552;
    protected static final int WMF_FLOODFILL = 1049;
    protected static final int WMF_FRAMEREGION = 1065;
    protected static final int WMF_INTERSECTCLIPRECT = 1046;
    protected static final int WMF_INVERTREGION = 298;
    protected static final int WMF_LINETO = 531;
    protected static final int WMF_MOVETO = 532;
    protected static final int WMF_OFFSETWINDOWORG = 527;
    protected static final int WMF_OFFSETVIEWPORTORG = 529;
    protected static final int WMF_PAINTREGION = 299;
    protected static final int WMF_PATBLT = 1565;
    protected static final int WMF_PIE = 2074;
    protected static final int WMF_POLYBEZIER16 = 4096;
    protected static final int WMF_POLYGON = 804;
    protected static final int WMF_POLYLINE = 805;
    protected static final int WMF_POLYPOLYGON = 1336;
    protected static final int WMF_REALIZEPALETTE = 53;
    protected static final int WMF_RESIZEPALETTE = 313;
    protected static final int WMF_RECTANGLE = 1051;
    protected static final int WMF_RESTOREDC = 295;
    protected static final int WMF_ROUNDRECT = 1564;
    protected static final int WMF_SAVEDC = 30;
    protected static final int WMF_SCALEWINDOWEXT = 1040;
    protected static final int WMF_SCALEVIEWPORTEXT = 1042;
    protected static final int WMF_SELECTCLIPREGION = 300;
    protected static final int WMF_SELECTPALETTE = 564;
    protected static final int WMF_SELECTOBJECT = 301;
    protected static final int WMF_SETBKCOLOR = 513;
    protected static final int WMF_SETBKMODE = 258;
    protected static final int WMF_SETDIBTODEV = 3379;
    protected static final int WMF_SETLAYOUT = 329;
    protected static final int WMF_SETMAPPERFLAGS = 561;
    protected static final int WMF_SETMAPMODE = 259;
    protected static final int WMF_SETRELABS = 261;
    protected static final int WMF_SETROP2 = 260;
    protected static final int WMF_SETPALENTRIES = 55;
    protected static final int WMF_SETPIXEL = 1055;
    protected static final int WMF_SETPOLYFILLMODE = 262;
    protected static final int WMF_SETSTRETCHBLTMODE = 263;
    protected static final int WMF_SETTEXTALIGN = 302;
    protected static final int WMF_SETTEXTCHAREXTRA = 264;
    protected static final int WMF_SETTEXTCOLOR = 521;
    protected static final int WMF_SETTEXTJUSTIFICATION = 522;
    protected static final int WMF_SETWINDOWEXT = 524;
    protected static final int WMF_SETWINDOWORG = 523;
    protected static final int WMF_SETVIEWPORTEXT = 526;
    protected static final int WMF_SETVIEWPORTORG = 525;
    protected static final int WMF_STRETCHBLT = 2851;
    protected static final int WMF_STRETCHDIB = 3907;
    protected static final int WMF_TEXTOUT = 1313;

    private Record readHeader(BufferedInputStream stream) throws IOException {
        stream.mark(1000);
        Record rec = new Record(0, 22, stream);
        int signature = (int)rec.getDWORDAt(0);
        if (signature == -1698247209) {
            stream.reset();
            rec = new Record(65535, 40, stream);
        } else {
            stream.reset();
            rec = new Record(65535, 18, stream);
        }
        return rec;
    }

    @Override
    protected Record getNextRecord(BufferedInputStream stream, int curRecord) throws IOException {
        if (curRecord == 0) {
            return this.readHeader(stream);
        }
        WMFRecord rec = new WMFRecord(stream);
        if (rec.getType() == 0) {
            return null;
        }
        return rec;
    }

    @Override
    protected IRenderableObject getConverter(Record rec) throws TranscoderException {
        IWmf2SvgConverter svgConverter = null;
        switch (rec.getType()) {
            case 65535: {
                svgConverter = new Header();
                break;
            }
            case 259: {
                svgConverter = new SetMapMode();
                break;
            }
            case 524: {
                svgConverter = new SetWindowExtent();
                break;
            }
            case 523: {
                svgConverter = new SetWindowOrg();
                break;
            }
            case 526: {
                svgConverter = new SetViewportExtent();
                break;
            }
            case 525: {
                svgConverter = new SetViewportOrg();
                break;
            }
            case 262: {
                svgConverter = new SetPolyFillMode();
                break;
            }
            case 258: {
                svgConverter = new SetBkMode();
                break;
            }
            case 513: {
                svgConverter = new SetBkColor();
                break;
            }
            case 30: {
                svgConverter = new SaveDC();
                break;
            }
            case 295: {
                svgConverter = new RestoreDC();
                break;
            }
            case 301: {
                svgConverter = new SelectObject();
                break;
            }
            case 496: {
                svgConverter = new DeleteObject();
                break;
            }
            case 764: {
                svgConverter = new CreateBrushIndirect();
                break;
            }
            case 762: {
                svgConverter = new CreatePen();
                break;
            }
            case 763: {
                svgConverter = new CreateFontIndirect();
                break;
            }
            case 521: {
                svgConverter = new SetTextColor();
                break;
            }
            case 302: {
                svgConverter = new SetTextAlign();
                break;
            }
            case 804: {
                svgConverter = new Polygon(true);
                break;
            }
            case 805: {
                svgConverter = new Polyline(true);
                break;
            }
            case 4096: {
                svgConverter = new PolyBezier(true, false);
                break;
            }
            case 1051: {
                svgConverter = new Rectangle();
                break;
            }
            case 1564: {
                svgConverter = new RoundRect();
                break;
            }
            case 531: {
                svgConverter = new LineTo();
                break;
            }
            case 532: {
                svgConverter = new MoveTo();
                break;
            }
            case 1048: {
                svgConverter = new Ellipse();
                break;
            }
            case 2610: {
                svgConverter = new ExtTextOut(false);
                break;
            }
            case 300: {
                svgConverter = new SelectClipRgn();
                break;
            }
            case 1046: {
                svgConverter = new IntersectClipRect();
                break;
            }
            case 1336: {
                svgConverter = new PolyPolygon(true);
                break;
            }
            case 2071: {
                svgConverter = new Arc(1);
                break;
            }
            case 2096: {
                svgConverter = new Arc(4);
                break;
            }
            case 2074: {
                svgConverter = new Arc(3);
                break;
            }
            case 263: {
                svgConverter = new SetStretchBltMode();
                break;
            }
            case 260: {
                svgConverter = new SetROP2();
                break;
            }
            case 505: {
                svgConverter = new CreatePatternBrush(false);
                break;
            }
            case 322: {
                svgConverter = new CreatePatternBrush(true);
                break;
            }
            case 3907: {
                svgConverter = new StretchBlt();
                break;
            }
            case 2881: {
                svgConverter = new StretchDIBits();
                break;
            }
            case 2368: {
                svgConverter = new BitBlt();
                break;
            }
            case 53: 
            case 247: 
            case 313: 
            case 564: 
            case 1078: 
            case 1574: {
                svgConverter = new Noop();
                break;
            }
            case 2851: {
                break;
            }
            case 2338: {
                break;
            }
            case 55: 
            case 261: 
            case 264: 
            case 298: 
            case 299: 
            case 329: 
            case 522: 
            case 527: 
            case 529: 
            case 552: 
            case 561: 
            case 1040: 
            case 1042: 
            case 1045: 
            case 1049: 
            case 1055: 
            case 1065: 
            case 1313: 
            case 1352: 
            case 1565: 
            case 1791: 
            case 3379: {
                break;
            }
        }
        if (svgConverter != null) {
            this.initializeConverter(svgConverter, rec);
        }
        return svgConverter;
    }

    private void initializeConverter(IRenderableObject svgConverter, Record rec) throws TranscoderException {
        try {
            IWmf2SvgConverter converter = (IWmf2SvgConverter)svgConverter;
            converter.readWMFRecord(rec);
            if (converter instanceof Header) {
                Header header = (Header)converter;
                this.setSize(new Dimension(header.getBounds().width, header.getBounds().height));
            }
        }
        catch (IOException e) {
            throw new TranscoderException(e, false);
        }
    }

    @Override
    protected String getUserFriendlyName(int recordType) {
        String name = "";
        switch (recordType) {
            case 65535: {
                name = "FAKE_HEADER";
                break;
            }
            case 1078: {
                name = "ANIMATEPALETTE";
                break;
            }
            case 2071: {
                name = "ARC";
                break;
            }
            case 2338: {
                name = "BITBLT";
                break;
            }
            case 2096: {
                name = "CHORD";
                break;
            }
            case 764: {
                name = "CREATEBRUSHINDIRECT";
                break;
            }
            case 763: {
                name = "CREATEFONTINDIRECT";
                break;
            }
            case 247: {
                name = "CREATEPALETTE";
                break;
            }
            case 505: {
                name = "CREATEPATTERNBRUSH";
                break;
            }
            case 762: {
                name = "CREATEPENINDIRECT";
                break;
            }
            case 1791: {
                name = "CREATEREGION";
                break;
            }
            case 496: {
                name = "DELETEOBJECT";
                break;
            }
            case 2368: {
                name = "DIBBITBLT";
                break;
            }
            case 322: {
                name = "DIBCREATEPATTERNBRUSH";
                break;
            }
            case 2881: {
                name = "DIBSTRETCHBLT";
                break;
            }
            case 1583: {
                name = "DRAWTEXT";
                break;
            }
            case 1048: {
                name = "ELLIPSE";
                break;
            }
            case 1574: {
                name = "ESCAPE";
                break;
            }
            case 1045: {
                name = "EXCLUDECLIPRECT";
                break;
            }
            case 1352: {
                name = "EXTFLOODFILL";
                break;
            }
            case 2610: {
                name = "EXTTEXTOUT";
                break;
            }
            case 552: {
                name = "FILLREGION";
                break;
            }
            case 1049: {
                name = "FLOODFILL";
                break;
            }
            case 1065: {
                name = "FRAMEREGION";
                break;
            }
            case 1046: {
                name = "INTERSECTCLIPRECT";
                break;
            }
            case 298: {
                name = "INVERTREGION";
                break;
            }
            case 531: {
                name = "LINETO";
                break;
            }
            case 532: {
                name = "MOVETO";
                break;
            }
            case 527: {
                name = "OFFSETWINDOWORG";
                break;
            }
            case 529: {
                name = "OFFSETVIEWPORTORG";
                break;
            }
            case 299: {
                name = "PAINTREGION";
                break;
            }
            case 1565: {
                name = "PATBLT";
                break;
            }
            case 2074: {
                name = "PIE";
                break;
            }
            case 4096: {
                name = "POLYBEZIER16";
                break;
            }
            case 804: {
                name = "POLYGON";
                break;
            }
            case 805: {
                name = "POLYLINE";
                break;
            }
            case 1336: {
                name = "POLYPOLYGON";
                break;
            }
            case 53: {
                name = "REALIZEPALETTE";
                break;
            }
            case 313: {
                name = "RESIZEPALETTE";
                break;
            }
            case 1051: {
                name = "RECTANGLE";
                break;
            }
            case 295: {
                name = "RESTOREDC";
                break;
            }
            case 1564: {
                name = "ROUNDRECT";
                break;
            }
            case 30: {
                name = "SAVEDC";
                break;
            }
            case 1040: {
                name = "SCALEWINDOWEXT";
                break;
            }
            case 1042: {
                name = "SCALEVIEWPORTEXT";
                break;
            }
            case 300: {
                name = "SELECTCLIPREGION";
                break;
            }
            case 564: {
                name = "SELECTPALETTE";
                break;
            }
            case 301: {
                name = "SELECTOBJECT";
                break;
            }
            case 513: {
                name = "SETBKCOLOR";
                break;
            }
            case 258: {
                name = "SETBKMODE";
                break;
            }
            case 3379: {
                name = "SETDIBTODEV";
                break;
            }
            case 329: {
                name = "SETLAYOUT";
                break;
            }
            case 561: {
                name = "SETMAPPERFLAGS";
                break;
            }
            case 259: {
                name = "SETMAPMODE";
                break;
            }
            case 261: {
                name = "SETRELABS";
                break;
            }
            case 260: {
                name = "SETROP2";
                break;
            }
            case 55: {
                name = "SETPALENTRIES";
                break;
            }
            case 1055: {
                name = "SETPIXEL";
                break;
            }
            case 262: {
                name = "SETPOLYFILLMODE";
                break;
            }
            case 263: {
                name = "SETSTRETCHBLTMODE";
                break;
            }
            case 302: {
                name = "SETTEXTALIGN";
                break;
            }
            case 264: {
                name = "SETTEXTCHAREXTRA";
                break;
            }
            case 521: {
                name = "SETTEXTCOLOR";
                break;
            }
            case 522: {
                name = "SETTEXTJUSTIFICATION";
                break;
            }
            case 524: {
                name = "SETWINDOWEXT";
                break;
            }
            case 523: {
                name = "SETWINDOWORG";
                break;
            }
            case 526: {
                name = "SETVIEWPORTEXT";
                break;
            }
            case 525: {
                name = "SETVIEWPORTORG";
                break;
            }
            case 2851: {
                name = "STRETCHBLT";
                break;
            }
            case 3907: {
                name = "STRETCHDIB";
                break;
            }
            case 1313: {
                name = "TEXTOUT";
                break;
            }
            default: {
                name = "<unknown>";
            }
        }
        return name;
    }
}

