/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.AbstractTranscoder;
import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.GdiBrush;
import com.benryan.graphics.emf.GdiFont;
import com.benryan.graphics.emf.GdiPen;
import com.benryan.graphics.emf.GdiRegion;
import com.benryan.graphics.emf.ITraceMe;
import com.benryan.graphics.emf.ObjectBase;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Color;
import java.awt.Graphics2D;

public class SelectObject
extends ObjectBase
implements ITraceMe {
    private String m_trace = null;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        Object obj = context.getGDI(this.getId());
        if (obj != null) {
            this.m_trace = Integer.toString(this.getId());
            if (obj instanceof GdiFont) {
                GdiFont gdiFont = (GdiFont)obj;
                context.setCurFont(gdiFont);
                return;
            }
            if (obj instanceof GdiBrush) {
                GdiBrush gdiBrush = (GdiBrush)obj;
                context.setCurBrush(gdiBrush);
                return;
            }
            if (obj instanceof GdiPen) {
                GdiPen pen = (GdiPen)obj;
                context.setCurPen(pen);
                return;
            }
            if (obj instanceof GdiRegion) {
                GdiRegion rgn = (GdiRegion)obj;
                context.setCurRegion(rgn);
                return;
            }
            AbstractTranscoder.logMessage(this.getClass().getName() + "Invalid object type in select object, object #" + this.getId());
            return;
        }
        if ((this.getId() & Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            AbstractTranscoder.logMessage(this.getClass().getName() + ": SelectObject failed to select object #" + this.getId());
            return;
        }
        int objectType = this.getId() & Integer.MAX_VALUE;
        switch (objectType) {
            case 0: {
                this.m_trace = "WHITE_BRUSH";
                context.setCurBrush(new GdiBrush(0, Color.white, 0));
                return;
            }
            case 1: {
                this.m_trace = "LTGRAY_BRUSH";
                context.setCurBrush(new GdiBrush(0, Color.lightGray, 0));
                return;
            }
            case 2: {
                this.m_trace = "GRAY_BRUSH";
                context.setCurBrush(new GdiBrush(0, Color.gray, 0));
                return;
            }
            case 3: {
                this.m_trace = "DKGRAY_BRUSH";
                context.setCurBrush(new GdiBrush(0, Color.darkGray, 0));
                return;
            }
            case 4: {
                this.m_trace = "BLACK_BRUSH";
                context.setCurBrush(new GdiBrush(0, Color.black, 0));
                return;
            }
            case 5: {
                this.m_trace = "NULL_BRUSH";
                context.setCurBrush(null);
                return;
            }
            case 6: {
                this.m_trace = "WHITE_PEN";
                context.setCurPen(new GdiPen(0, 1, Color.white));
                return;
            }
            case 7: {
                this.m_trace = "BLACK_PEN";
                context.setCurPen(new GdiPen(0, 1, Color.black));
                return;
            }
            case 8: {
                this.m_trace = "NULL_PEN";
                context.setCurPen(null);
                return;
            }
            case 10: {
                this.m_trace = "OEM_FIXED_FONT";
                context.setCurFont(new GdiFont(10, false, false, false, false, "Monospaced", 0));
                return;
            }
            case 11: {
                this.m_trace = "ANSI_FIXED_FONT";
                context.setCurFont(new GdiFont(10, false, false, false, false, "Monospaced", 0));
                return;
            }
            case 12: {
                this.m_trace = "ANSI_VAR_FONT";
                context.setCurFont(new GdiFont(10, false, false, false, false, "SanSerif", 0));
                return;
            }
            case 13: {
                this.m_trace = "SYSTEM_FONT";
                context.setCurFont(new GdiFont(12, false, false, false, true, "System", 0));
                return;
            }
            case 14: {
                this.m_trace = "DEVICE_DEFAULT_FONT";
                context.setCurFont(new GdiFont(10, false, false, false, false, "Dialog", 0));
                return;
            }
            case 16: {
                this.m_trace = "SYSTEM_FIXED_FONT";
                context.setCurFont(new GdiFont(10, false, false, false, false, "Monospaced", 0));
                return;
            }
            case 15: {
                this.m_trace = "DEFAULT_PALETTE";
                return;
            }
        }
    }

    public String toString() {
        return this.m_trace;
    }
}

