/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.GdiBrush;
import com.benryan.graphics.emf.GdiPen;
import com.benryan.graphics.emf.IEmf2SvgConverter;
import com.benryan.graphics.emf.IRenderToPath;
import com.benryan.graphics.emf.IWmf2SvgConverter;
import com.benryan.graphics.emf.Record;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class Rectangle
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath {
    private static final int WMF_BOTTOM_OFFSET = 0;
    private static final int WMF_RIGHT_OFFSET = 2;
    private static final int WMF_TOP_OFFSET = 4;
    private static final int WMF_LEFT_OFFSET = 6;
    private java.awt.Rectangle m_rect;

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        short bottom = rec.getShortAt(0);
        short right = rec.getShortAt(2);
        short top = rec.getShortAt(4);
        short left = rec.getShortAt(6);
        this.m_rect = new java.awt.Rectangle(left, top, right - left, bottom - top);
    }

    @Override
    public void readEMFRecord(Record rec) throws IOException {
        this.m_rect = rec.getRectangleLAt(0);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen pen;
        Shape s = this.getShape(context);
        GdiBrush brush = context.getCurBrush();
        if (brush != null) {
            brush.fill(s, g, context);
        }
        if ((pen = context.getCurPen()) != null) {
            pen.apply(g, context);
            g.draw(s);
        }
    }

    @Override
    public void render(DeviceContext context) {
        Shape s = this.getShape(context);
        context.getGdiPath().appendFigure(s);
    }

    private Shape getShape(DeviceContext context) {
        int x = context.convertXToSVGLogicalUnits(this.m_rect.x);
        int y = context.convertYToSVGLogicalUnits(this.m_rect.y);
        int w = context.scaleX(this.m_rect.width);
        int h = context.scaleY(this.m_rect.height);
        return new Rectangle2D.Float(x, y, w, h);
    }
}

