/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.AbstractPoly;
import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.GdiPen;
import com.benryan.graphics.emf.IRenderToPath;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class PolylineTo
extends AbstractPoly
implements IRenderToPath {
    public PolylineTo(boolean b16Bits) {
        super(b16Bits);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        if (this.getCount() > 0) {
            GdiPen curPen = context.getCurPen();
            if (curPen != null) {
                curPen.apply(g, context);
                g.drawLine(context.convertXToSVGLogicalUnits(context.getCurPosX()), context.convertYToSVGLogicalUnits(context.getCurPosY()), context.convertXToSVGLogicalUnits(this.getXPoints()[0]), context.convertYToSVGLogicalUnits(this.getYPoints()[0]));
                g.drawPolygon(context.convertXArrayToSVGLogicalUnits(this.getXPoints()), context.convertYArrayToSVGLogicalUnits(this.getYPoints()), this.getCount());
            }
            context.setCurPosX(this.getXPoints()[this.getCount() - 1]);
            context.setCurPosY(this.getYPoints()[this.getCount() - 1]);
        }
    }

    @Override
    public void render(DeviceContext context) {
        Shape s = this.getShape(context);
        context.getGdiPath().getCurrentFigure().append(s, true);
        context.setCurPosX(this.getXPoints()[this.getCount() - 1]);
        context.setCurPosY(this.getYPoints()[this.getCount() - 1]);
    }

    private Shape getShape(DeviceContext context) {
        GeneralPath p = new GeneralPath();
        int count = this.getCount();
        if (count > 0) {
            this.m_xPointsConv = context.convertXArrayToSVGLogicalUnits(this.getXPoints());
            this.m_yPointsConv = context.convertYArrayToSVGLogicalUnits(this.getYPoints());
            p.moveTo(this.m_xPointsConv[0], this.m_yPointsConv[0]);
            for (int index = 1; index < count; ++index) {
                p.lineTo(this.m_xPointsConv[index], this.m_yPointsConv[index]);
            }
        }
        return p;
    }
}

