/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.AbstractPolyPoly;
import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.GdiBrush;
import com.benryan.graphics.emf.GdiPen;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class PolyPolygon
extends AbstractPolyPoly {
    public PolyPolygon(boolean b16Bits) {
        super(b16Bits);
    }

    @Override
    protected boolean renderPoly(Graphics2D g, DeviceContext context, int[] xPoints, int[] yPoints, int nPoints) {
        GdiPen curPen;
        GdiBrush curBrush = context.getCurBrush();
        Shape s = this.getShape(xPoints, yPoints, nPoints);
        if (curBrush != null) {
            curBrush.fill(s, g, context);
        }
        if ((curPen = context.getCurPen()) != null) {
            curPen.apply(g, context);
            g.draw(s);
        }
        return true;
    }

    @Override
    protected boolean renderPoly(GeneralPath p, int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints > 0) {
            p.moveTo(xPoints[0], yPoints[0]);
            for (int index = 1; index < nPoints; ++index) {
                p.lineTo(xPoints[index], yPoints[index]);
            }
            p.closePath();
        }
        return true;
    }

    private Shape getShape(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = new GeneralPath();
        if (nPoints > 0) {
            p.moveTo(xPoints[0], yPoints[0]);
            for (int index = 1; index < nPoints; ++index) {
                p.lineTo(xPoints[index], yPoints[index]);
            }
            p.closePath();
        }
        return p;
    }
}

