/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.AbstractPoly;
import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.GdiPen;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class PolyBezier
extends AbstractPoly {
    private boolean m_bTo = false;

    public PolyBezier(boolean b16Bits, boolean bTo) {
        super(b16Bits);
        this.m_bTo = bTo;
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen pen = context.getCurPen();
        if (pen != null) {
            pen.apply(g, context);
            int count = this.getCount();
            if (count > 0) {
                Shape shape = this.getShape(context);
                g.draw(shape);
                if (this.m_bTo) {
                    context.setCurPosX(this.getXPoints()[count - 1]);
                    context.setCurPosY(this.getYPoints()[count - 1]);
                }
            }
        }
    }

    @Override
    public void render(DeviceContext context) {
        int count = this.getCount();
        if (count > 0) {
            Shape shape = this.getShape(context);
            if (this.m_bTo) {
                context.getGdiPath().getCurrentFigure().append(shape, true);
                context.setCurPosX(this.getXPoints()[count - 1]);
                context.setCurPosY(this.getYPoints()[count - 1]);
            } else {
                context.getGdiPath().appendFigure(shape);
            }
        }
    }

    private Shape getShape(DeviceContext context) {
        GeneralPath genPath = new GeneralPath(1);
        int count = this.getCount();
        if (count > 0) {
            int startIndex;
            this.m_xPointsConv = context.convertXArrayToSVGLogicalUnits(this.getXPoints());
            this.m_yPointsConv = context.convertYArrayToSVGLogicalUnits(this.getYPoints());
            if (this.m_bTo) {
                startIndex = 0;
                if (!context.getGdiPath().isOpen()) {
                    genPath.moveTo(context.convertXToSVGLogicalUnits(context.getCurPosX()), context.convertYToSVGLogicalUnits(context.getCurPosY()));
                } else {
                    Point2D curPos = context.getGdiPath().getCurrentFigure().getCurrentPoint();
                    genPath.moveTo((float)curPos.getX(), (float)curPos.getY());
                }
            } else {
                genPath.moveTo(this.m_xPointsConv[0], this.m_yPointsConv[0]);
                startIndex = 1;
            }
            for (int j = startIndex; j <= count - 3; j += 3) {
                int firstControlPointX = this.m_xPointsConv[j];
                int firstControlPointY = this.m_yPointsConv[j];
                int secondControlPointX = this.m_xPointsConv[j + 1];
                int secondControlPointY = this.m_yPointsConv[j + 1];
                int endPointX = this.m_xPointsConv[j + 2];
                int endPointY = this.m_yPointsConv[j + 2];
                genPath.curveTo(firstControlPointX, firstControlPointY, secondControlPointX, secondControlPointY, endPointX, endPointY);
            }
        }
        return genPath;
    }
}

