/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.GdiPen;
import com.benryan.graphics.emf.IEmf2SvgConverter;
import com.benryan.graphics.emf.IRenderToPath;
import com.benryan.graphics.emf.IWmf2SvgConverter;
import com.benryan.graphics.emf.Record;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;

public class LineTo
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath {
    private static final int EMF_X_OFFSET = 0;
    private static final int EMF_Y_OFFSET = 4;
    private static final int WMF_X_OFFSET = 2;
    private static final int WMF_Y_OFFSET = 0;
    private int m_xPos = 0;
    private int m_yPos = 0;
    private int m_xPosConv = -1;
    private int m_yPosConv = -1;

    @Override
    public void readWMFRecord(Record emr) throws IOException {
        this.m_xPos = emr.getShortAt(2);
        this.m_yPos = emr.getShortAt(0);
    }

    @Override
    public void readEMFRecord(Record emr) throws IOException {
        this.m_xPos = emr.getIntAt(0);
        this.m_yPos = emr.getIntAt(4);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen curPen = context.getCurPen();
        if (curPen != null) {
            curPen.apply(g, context);
            this.m_xPosConv = context.convertXToSVGLogicalUnits(this.m_xPos);
            this.m_yPosConv = context.convertYToSVGLogicalUnits(this.m_yPos);
            g.drawLine(context.convertXToSVGLogicalUnits(context.getCurPosX()), context.convertYToSVGLogicalUnits(context.getCurPosY()), this.m_xPosConv, this.m_yPosConv);
        }
        context.setCurPosX(this.m_xPos);
        context.setCurPosY(this.m_yPos);
    }

    @Override
    public void render(DeviceContext context) {
        GeneralPath p = context.getGdiPath().getCurrentFigure();
        this.m_xPosConv = context.convertXToSVGLogicalUnits(this.m_xPos);
        this.m_yPosConv = context.convertYToSVGLogicalUnits(this.m_yPos);
        p.lineTo(this.m_xPosConv, this.m_yPosConv);
        context.setCurPosX(this.m_xPos);
        context.setCurPosY(this.m_yPos);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        sb.append(this.m_xPosConv);
        sb.append(',');
        sb.append(this.m_yPosConv);
        sb.append(')');
        return sb.toString();
    }
}

