/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.IWmf2SvgConverter;
import com.benryan.graphics.emf.Record;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;

class IntersectClipRect
implements IWmf2SvgConverter {
    private static final int LEFT_OFFSET = 6;
    private static final int TOP_OFFSET = 4;
    private static final int RIGHT_OFFSET = 2;
    private static final int BOTTOM_OFFSET = 0;
    private static Rectangle m_rect;

    IntersectClipRect() {
    }

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        short x = rec.getShortAt(6);
        short y = rec.getShortAt(4);
        short x1 = rec.getShortAt(2);
        short y1 = rec.getShortAt(0);
        m_rect = new Rectangle(x, y, x1 - x, y1 - y);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        Rectangle rect = context.convertRectangleToSVGLogicalUnits(m_rect);
        g.clip(rect);
    }
}

