/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.DeviceContext;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Vector;

public class GdiPath {
    private Vector m_figures = new Vector();
    private boolean m_bPathIsOpen = false;
    private DeviceContext m_context = null;
    private GeneralPath m_curFigure = null;

    public GdiPath(DeviceContext context) {
        this.m_context = context;
    }

    GdiPath(DeviceContext context, GdiPath path) {
        this.m_bPathIsOpen = path.m_bPathIsOpen;
        this.m_context = context;
        for (int index = 0; index < path.m_figures.size(); ++index) {
            GeneralPath p = (GeneralPath)path.m_figures.get(index);
            GeneralPath newP = new GeneralPath(p);
            this.m_figures.add(newP);
            if (p != path.m_curFigure) continue;
            this.m_curFigure = newP;
        }
    }

    public void begin() {
        this.m_figures.clear();
        this.newFigure();
        this.m_curFigure = null;
        this.m_bPathIsOpen = true;
    }

    public void end() {
        this.m_bPathIsOpen = false;
    }

    public void abort() {
        this.m_bPathIsOpen = false;
        this.m_curFigure = null;
        this.m_figures.clear();
    }

    public boolean isOpen() {
        return this.m_bPathIsOpen;
    }

    public void appendFigure(GeneralPath s) {
        if (this.m_bPathIsOpen) {
            this.m_figures.add(s);
            this.m_curFigure = null;
        }
    }

    public void appendFigure(Shape s) {
        if (this.m_bPathIsOpen) {
            GeneralPath p = new GeneralPath();
            p.append(s, false);
            this.m_figures.add(p);
            this.m_curFigure = null;
        }
    }

    public void closeAll() {
        for (int index = 0; index < this.m_figures.size(); ++index) {
            GeneralPath gp = (GeneralPath)this.m_figures.get(index);
            if (gp == null) continue;
            gp.closePath();
        }
    }

    public GeneralPath getCurrentFigure() {
        if (this.m_curFigure == null) {
            this.m_curFigure = this.newFigure();
        }
        return this.m_curFigure;
    }

    public GeneralPath getPath() {
        GeneralPath path = new GeneralPath();
        for (int index = 0; index < this.m_figures.size(); ++index) {
            path.append((Shape)this.m_figures.get(index), false);
        }
        return path;
    }

    public void flatten() {
        for (int index = 0; index < this.m_figures.size(); ++index) {
            GeneralPath gp = (GeneralPath)this.m_figures.get(index);
            if (gp == null) continue;
            gp = this.flatten(gp);
            this.m_figures.remove(index);
            this.m_figures.insertElementAt(gp, index);
        }
    }

    private GeneralPath newFigure() {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(this.m_context.convertXToSVGLogicalUnits(this.m_context.getCurPosX()), this.m_context.convertYToSVGLogicalUnits(this.m_context.getCurPosY()));
        this.m_figures.add(gp);
        return gp;
    }

    private GeneralPath flatten(GeneralPath gp) {
        PathIterator it = gp.getPathIterator(new AffineTransform());
        FlatteningPathIterator flatIterator = new FlatteningPathIterator(it, 20.0);
        GeneralPath retval = new GeneralPath();
        retval.append(flatIterator, false);
        return retval;
    }
}

