/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.GdiBrush;
import com.benryan.graphics.emf.GdiFont;
import com.benryan.graphics.emf.GdiPath;
import com.benryan.graphics.emf.GdiPen;
import com.benryan.graphics.emf.GdiRegion;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public final class DeviceContext {
    private Vector m_deviceContexts = new Vector();
    private DeviceContext m_curDeviceContext = this;
    private Rectangle m_bounds = new Rectangle(0, 0, 100, 100);
    private int m_dpiX = 72;
    private int m_dpiY = 72;
    private int m_curPosX = 0;
    private int m_curPosY = 0;
    private Point m_vpOrigin = new Point(0, 0);
    private Point m_vpExtent = new Point(1000, 1000);
    private Point m_winOrigin = new Point(0, 0);
    private Point m_winExtent = new Point(1000, 1000);
    private int m_mapMode = 1;
    private int m_textAlignment = 0;
    private int m_fillMode = 1;
    private int m_arcDirection = 1;
    private float m_miterLimit = 10.0f;
    private int m_bkMode = 1;
    private int m_stretchBltMode = 3;
    private int m_ROP2 = 13;
    private Color m_backColor = new Color(0xFFFFFF);
    private Color m_textColor = new Color(0);
    private GdiFont m_curFont = new GdiFont();
    private GdiBrush m_curBrush = new GdiBrush();
    private GdiPen m_curPen = new GdiPen();
    private GdiRegion m_curRegion = new GdiRegion((Shape)null);
    private Map m_gdiObjectMap = new HashMap();
    private Map m_userProps = new HashMap();
    private GdiPath m_path = new GdiPath(this);
    private float[] m_xform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    private static final int _11 = 0;
    private static final int _12 = 1;
    private static final int _21 = 2;
    private static final int _22 = 3;
    private static final int _31 = 4;
    private static final int _32 = 5;
    public static final int MWT_IDENTITY = 1;
    public static final int MWT_LEFTMULTIPLY = 2;
    public static final int MWT_RIGHTMULTIPLY = 3;
    private static final int MM_TEXT = 1;
    private static final int MM_LOMETRIC = 2;
    private static final int MM_HIMETRIC = 3;
    private static final int MM_LOENGLISH = 4;
    private static final int MM_HIENGLISH = 5;
    private static final int MM_TWIPS = 6;
    private static final int MM_ISOTROPIC = 7;
    private static final int MM_ANISOTROPIC = 8;
    private static final int DPI = 72;
    private static final int HI_METRIC_PER_INCH = 2540;
    private static final int LO_METRIC_PER_INCH = 254;
    private static final int HI_ENGLISH_PER_INCH = 1000;
    private static final int LO_ENGLISH_PER_INCH = 100;
    private static final int TWIPS_PER_INCH = 1440;
    private static final int COLORONCOLOR = 3;
    private static final int R2_COPYPEN = 13;
    public static final int DIB_RGB_COLORS = 0;
    public static final int DIB_PAL_COLORS = 1;
    public static final int TRANSPARENT = 1;
    public static final int OPAQUE = 2;
    public static final int FILL_MODE_ALTERNATE = 1;
    public static final int FILL_MODE_WINDING = 2;
    public static final int AD_COUNTERCLOCKWISE = 1;
    public static final int AD_CLOCKWISE = 2;
    public static final int TA_TOP = 0;
    public static final int TA_LEFT = 0;
    public static final int TA_UPDATECP = 1;
    public static final int TA_RIGHT = 2;
    public static final int TA_CENTER = 6;
    public static final int TA_BOTTOM = 8;
    public static final int TA_BASELINE = 24;
    public static final int TA_RTLREADING = 256;

    public DeviceContext() {
    }

    private DeviceContext(DeviceContext context) {
        this.copy(context);
    }

    private void copy(DeviceContext context) {
        this.m_bounds = new Rectangle(context.m_bounds);
        this.m_dpiX = context.m_dpiX;
        this.m_dpiY = context.m_dpiY;
        this.m_curPosX = context.m_curPosX;
        this.m_curPosY = context.m_curPosY;
        this.m_vpOrigin = new Point(context.m_vpOrigin);
        this.m_vpExtent = new Point(context.m_vpExtent);
        this.m_winOrigin = new Point(context.m_winOrigin);
        this.m_winExtent = new Point(context.m_winExtent);
        this.m_mapMode = context.m_mapMode;
        this.m_textAlignment = context.m_textAlignment;
        this.m_fillMode = context.m_fillMode;
        this.m_arcDirection = context.m_arcDirection;
        this.m_miterLimit = context.m_miterLimit;
        this.m_bkMode = context.m_bkMode;
        this.m_backColor = new Color(context.m_backColor.getRGB());
        this.m_textColor = new Color(context.m_textColor.getRGB());
        this.m_curFont = new GdiFont(context.m_curFont);
        this.m_curBrush = new GdiBrush(context.m_curBrush);
        this.m_curPen = new GdiPen(context.m_curPen);
        this.m_curRegion = new GdiRegion(context.m_curRegion);
        this.m_path = new GdiPath(this, context.m_path);
    }

    public void saveDC() {
        this.m_deviceContexts.add(new DeviceContext(this));
    }

    public void restoreDC(int dcIndex) {
        int realIndex = 0;
        realIndex = dcIndex < 0 ? -dcIndex - 1 : this.m_deviceContexts.size() - dcIndex;
        if (realIndex < this.m_deviceContexts.size()) {
            DeviceContext context = (DeviceContext)this.m_deviceContexts.get(realIndex);
            this.m_curDeviceContext.copy(context);
            for (int index = 0; index <= realIndex; ++index) {
                this.m_deviceContexts.remove(0);
            }
        }
    }

    public void setCurPosX(int x) {
        this.m_curPosX = x;
    }

    public int getCurPosX() {
        return this.m_curPosX;
    }

    public void setCurPosY(int y) {
        this.m_curPosY = y;
    }

    public int getCurPosY() {
        return this.m_curPosY;
    }

    public void setViewportOrigin(Point origin) {
        this.m_vpOrigin = new Point(origin);
    }

    public Point getViewportOrigin() {
        return new Point(this.m_vpOrigin);
    }

    public void setViewportExtent(Point ext) {
        this.m_vpExtent = new Point(ext);
    }

    public Point getViewportExtent() {
        return new Point(this.m_vpExtent);
    }

    public void setWindowOrigin(Point origin) {
        this.m_winOrigin = new Point(origin);
    }

    public Point getWindowOrigin() {
        return new Point(this.m_winOrigin);
    }

    public void setWindowExtent(Point extent) {
        this.m_winExtent = new Point(extent);
    }

    public Point getWindowExtent() {
        return new Point(this.m_winExtent);
    }

    public void setMapMode(int mode) {
        this.m_mapMode = mode;
    }

    public int getMapMode() {
        return this.m_mapMode;
    }

    public void modifyWorldTransform(int operation, float[] transform) {
        switch (operation) {
            case 1: {
                this.m_xform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
                break;
            }
            case 2: {
                this.m_xform = this.crossMultiply(transform, this.m_xform);
                break;
            }
            case 3: {
                this.m_xform = this.crossMultiply(this.m_xform, transform);
            }
        }
    }

    private float[] crossMultiply(float[] L, float[] R) {
        float[] P = new float[6];
        P[0] = L[0] * R[0] + L[1] * R[2];
        P[2] = L[2] * R[0] + L[3] * R[2];
        P[4] = L[4] * R[0] + L[5] * R[2] + 1.0f * R[4];
        P[1] = L[0] * R[1] + L[1] * R[3];
        P[3] = L[2] * R[1] + L[3] * R[3];
        P[5] = L[4] * R[1] + L[5] * R[3] + 1.0f * R[5];
        return P;
    }

    public int convertXToWindowsLogicalUnits(int x) {
        x += this.m_bounds.x;
        x -= this.m_vpOrigin.x;
        switch (this.m_mapMode) {
            case 1: {
                break;
            }
            case 4: {
                x = x * 100 / this.m_dpiX;
                break;
            }
            case 5: {
                x = x * 1000 / this.m_dpiX;
                break;
            }
            case 2: {
                x = x * 254 / this.m_dpiX;
                break;
            }
            case 3: {
                x = x * 2540 / this.m_dpiX;
                break;
            }
            case 6: {
                x = x * 1440 / this.m_dpiX;
                break;
            }
            case 8: {
                x = x * this.m_winExtent.x / this.m_vpExtent.x;
                break;
            }
            case 7: {
                x = x * this.m_winExtent.x / this.m_vpExtent.x;
            }
        }
        float f = (float)x / this.m_xform[0];
        return (int)f + this.m_winOrigin.x;
    }

    public int convertXToSVGLogicalUnits(int x) {
        x -= this.m_winOrigin.x;
        x = this.scaleX(x);
        x += (int)this.m_xform[4];
        x += this.m_vpOrigin.x;
        return x -= this.m_bounds.x;
    }

    public int scaleX(int x) {
        switch (this.m_mapMode) {
            case 1: {
                break;
            }
            case 4: {
                x = x * this.m_dpiX / 100;
                break;
            }
            case 5: {
                x = x * this.m_dpiX / 1000;
                break;
            }
            case 2: {
                x = x * this.m_dpiX / 254;
                break;
            }
            case 3: {
                x = x * this.m_dpiX / 2540;
                break;
            }
            case 6: {
                x = x * this.m_dpiX / 1440;
                break;
            }
            case 8: {
                x = x * this.m_vpExtent.x / this.m_winExtent.x;
                break;
            }
            case 7: {
                x = x * this.m_vpExtent.x / this.m_winExtent.x;
            }
        }
        float f = (float)x * this.m_xform[0];
        return (int)f;
    }

    public int convertYToWindowsLogicalUnits(int y) {
        y += this.m_bounds.y;
        y -= this.m_vpOrigin.y;
        switch (this.m_mapMode) {
            case 1: {
                break;
            }
            case 4: {
                y = y * 100 / this.m_dpiY;
                break;
            }
            case 5: {
                y = y * 1000 / this.m_dpiY;
                break;
            }
            case 2: {
                y = y * 254 / this.m_dpiY;
                break;
            }
            case 3: {
                y = y * 2540 / this.m_dpiY;
                break;
            }
            case 6: {
                y = y * 1440 / this.m_dpiY;
                break;
            }
            case 8: {
                y = y * this.m_winExtent.y / this.m_vpExtent.y;
                break;
            }
            case 7: {
                y = y * this.m_winExtent.x / this.m_vpExtent.x;
            }
        }
        float f = (float)y / this.m_xform[3];
        return (int)f + this.m_winOrigin.y;
    }

    public int convertYToSVGLogicalUnits(int y) {
        y -= this.m_winOrigin.y;
        y = this.scaleY(y);
        y += (int)this.m_xform[5];
        y += this.m_vpOrigin.y;
        return y -= this.m_bounds.y;
    }

    public int scaleY(int y) {
        switch (this.m_mapMode) {
            case 1: {
                break;
            }
            case 4: {
                y = -(y * this.m_dpiY) / 100;
                break;
            }
            case 5: {
                y = -(y * this.m_dpiY) / 1000;
                break;
            }
            case 2: {
                y = -(y * this.m_dpiY) / 254;
                break;
            }
            case 3: {
                y = -(y * this.m_dpiY) / 2540;
                break;
            }
            case 6: {
                y = -(y * this.m_dpiY) / 1440;
                break;
            }
            case 8: {
                y = y * this.m_vpExtent.y / this.m_winExtent.y;
                break;
            }
            case 7: {
                y = y * this.m_vpExtent.x / this.m_winExtent.x;
            }
        }
        float f = (float)y * this.m_xform[3];
        return (int)f;
    }

    public int[] convertXArrayToSVGLogicalUnits(int[] array) {
        int[] out = new int[array.length];
        for (int index = 0; index < array.length; ++index) {
            out[index] = this.convertXToSVGLogicalUnits(array[index]);
        }
        return out;
    }

    public int[] convertYArrayToSVGLogicalUnits(int[] array) {
        int[] out = new int[array.length];
        for (int index = 0; index < array.length; ++index) {
            out[index] = this.convertYToSVGLogicalUnits(array[index]);
        }
        return out;
    }

    public Rectangle convertRectangleToSVGLogicalUnits(Rectangle rect) {
        Rectangle converted = new Rectangle(rect);
        converted.x = this.convertXToSVGLogicalUnits(converted.x);
        converted.width = this.scaleX(converted.width);
        converted.y = this.convertYToSVGLogicalUnits(converted.y);
        converted.height = this.scaleY(converted.height);
        return converted;
    }

    public Dimension convertDimensionToSVGLogicalUnits(Dimension dim) {
        Dimension converted = new Dimension(dim);
        converted.width = this.scaleX(converted.width);
        converted.height = this.scaleY(converted.height);
        return converted;
    }

    public Point convertPointToSVGLogicalUnits(Point pt) {
        Point converted = new Point(pt);
        converted.x = this.convertXToSVGLogicalUnits(converted.x);
        converted.y = this.convertYToSVGLogicalUnits(converted.y);
        return converted;
    }

    public void setBackColor(Color color) {
        this.m_backColor = color;
    }

    public Color getBackColor() {
        return this.m_backColor;
    }

    public void setTextColor(Color color) {
        this.m_textColor = color;
    }

    public Color getTextColor() {
        return this.m_textColor;
    }

    public GdiFont getCurFont() {
        return this.m_curFont;
    }

    public void setCurFont(GdiFont font) {
        this.m_curFont = font;
    }

    public GdiBrush getCurBrush() {
        return this.m_curBrush;
    }

    public void setCurBrush(GdiBrush brush) {
        this.m_curBrush = brush;
    }

    public GdiPen getCurPen() {
        return this.m_curPen;
    }

    public void setCurPen(GdiPen pen) {
        this.m_curPen = pen;
    }

    public int getNextObjectId() {
        int objId = 0;
        while (this.m_curDeviceContext.m_gdiObjectMap.containsKey(new Integer(objId))) {
            ++objId;
        }
        return objId;
    }

    public void addGDI(int id, Object gdiObject) {
        this.m_gdiObjectMap.put(new Integer(id), gdiObject);
    }

    public Object getGDI(int id) {
        return this.m_gdiObjectMap.get(new Integer(id));
    }

    public void deleteGDI(int id) {
        this.m_gdiObjectMap.remove(new Integer(id));
    }

    public Rectangle getBounds() {
        return new Rectangle(this.m_bounds);
    }

    public void setBounds(Rectangle rect) {
        this.m_bounds = rect;
    }

    public int getDpiX() {
        return this.m_dpiX;
    }

    public void setDpiX(int dpi) {
        if (dpi >= 60) {
            this.m_dpiX = dpi;
        }
    }

    public int getDpiY() {
        return this.m_dpiY;
    }

    public void setDpiY(int dpi) {
        if (dpi >= 60) {
            this.m_dpiY = dpi;
        }
    }

    public int getTextAlignment() {
        return this.m_textAlignment;
    }

    public void setTextAlignment(int i) {
        this.m_textAlignment = i;
    }

    public int getPolyFillMode() {
        return this.m_fillMode;
    }

    public void setPolyFillMode(int fillMode) {
        this.m_fillMode = fillMode;
    }

    public int getArcDirection() {
        return this.m_arcDirection;
    }

    public void setArcDirection(int arcDirection) {
        this.m_arcDirection = arcDirection;
    }

    public GdiPath getGdiPath() {
        return this.m_path;
    }

    public float getMiterLimit() {
        return this.m_miterLimit;
    }

    public void setMiterLimit(float miterLimit) {
        if (miterLimit < 1.0f) {
            miterLimit = 1.0f;
        }
        this.m_miterLimit = miterLimit;
    }

    public int getBkMode() {
        return this.m_bkMode;
    }

    public void setBkMode(int bkMode) {
        this.m_bkMode = bkMode;
    }

    public GdiRegion getCurRegion() {
        return this.m_curRegion;
    }

    public void setCurRegion(GdiRegion curRegion) {
        this.m_curRegion = curRegion;
    }

    public int getStretchBltMode() {
        return this.m_stretchBltMode;
    }

    public void setStretchBltMode(int stretchBltMode) {
        this.m_stretchBltMode = stretchBltMode;
    }

    public int getROP2() {
        return this.m_ROP2;
    }

    public void setROP2(int rop2) {
        this.m_ROP2 = rop2;
    }

    public void setProperty(Object key, Object value) {
        this.m_userProps.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.m_userProps.get(key);
    }

    public void removeProperty(Object key) {
        this.m_userProps.remove(key);
    }
}

