/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.AbstractTranscoder;
import com.benryan.graphics.emf.BitmapHelper;
import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.GdiBrush;
import com.benryan.graphics.emf.IEmf2SvgConverter;
import com.benryan.graphics.emf.IWmf2SvgConverter;
import com.benryan.graphics.emf.Record;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CreatePatternBrush
implements IEmf2SvgConverter,
IWmf2SvgConverter {
    private static final int EMF_ID_OFFSET = 0;
    private static final int EMF_BMI_OFFSET_OFFSET = 8;
    private static final int EMF_BMI_SIZE_OFFSET = 12;
    private static final int EMF_BITS_OFFSET_OFFSET = 16;
    private static final int EMF_BITS_SIZE_OFFSET = 20;
    private static final int WMF_BMI_OFFSET = 4;
    private boolean m_bDibPattern = false;
    private int m_id = -1;
    private BufferedImage m_image = null;
    private int m_type = 9;

    public CreatePatternBrush(boolean bDibPattern) {
        this.m_bDibPattern = bDibPattern;
    }

    @Override
    public void readWMFRecord(Record rec) throws IOException {
        this.m_type = rec.getShortAt(0);
        int bmiOffset = 0;
        int bmiSize = 0;
        int bitOffset = 0;
        int bitSize = 0;
        switch (this.m_type) {
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                bmiOffset = 4;
                int tableSize = BitmapHelper.getNumberOfPaletteEntries(rec, 4);
                bmiSize = (int)rec.getDWORDAt(bmiOffset) + (tableSize *= 4);
                bitOffset = bmiOffset + bmiSize;
                bitSize = rec.getSize() - bitOffset;
                break;
            }
            default: {
                AbstractTranscoder.logMessage("Unknown/Unsupported pattern type encountered: " + this.m_type);
                return;
            }
        }
        this.m_image = BitmapHelper.readBitmap(rec, bmiOffset, bmiSize, bitOffset, bitSize);
    }

    @Override
    public void readEMFRecord(Record rec) throws IOException {
        if (this.m_bDibPattern) {
            this.m_type = 5;
        }
        this.m_id = (int)rec.getDWORDAt(0);
        int bmiOffset = (int)rec.getDWORDAt(8) - 8;
        int bmiSize = (int)rec.getDWORDAt(12);
        int bitOffset = (int)rec.getDWORDAt(16) - 8;
        int bitSize = (int)rec.getDWORDAt(20);
        this.m_image = BitmapHelper.readBitmap(rec, bmiOffset, bmiSize, bitOffset, bitSize);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        if (this.m_id == -1) {
            this.m_id = context.getNextObjectId();
        }
        context.addGDI(this.m_id, new GdiBrush(this.m_type, this.m_image));
    }
}

