/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.Record;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

class BitmapHelper {
    private static final int COMPRESSION_TYPE_OFFSET = 16;
    private static final int BMI_BITCOUNT_OFFSET = 14;
    private static final int BMI_COLORS_OFFSET = 32;
    private static final int BCH_BITCOUNT_OFFSET = 10;
    private static final int BI_BITFIELDS = 3;
    private static final int BASE_BMI_SIZE = 40;
    private static final int BASE_BCH_SIZE = 12;
    private static final int BLUE_MASK = 31;
    private static final int GREEN_MASK = 992;
    private static final int RED_MASK = 31744;

    BitmapHelper() {
    }

    static BufferedImage readBitmap(Record rec, int bmiOffset, int bmiSize, int bitOffset, int bitSize) throws IOException {
        int compressionType = rec.getIntAt(bmiOffset + 16);
        short bitCount = rec.getShortAt(bmiOffset + 14);
        int headerSize = 14;
        int size = bmiSize + bitSize + headerSize;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(66);
        out.write(77);
        BitmapHelper.writeInt(out, size);
        BitmapHelper.writeInt(out, 0);
        int dataOffset = headerSize + (bitOffset - bmiOffset);
        int numEntries = BitmapHelper.getNumberOfPaletteEntries(rec, bmiOffset);
        int requiredPaletteSize = numEntries * 4;
        int actualPaletteSize = bitOffset - bmiOffset - 40;
        int numFakePaletteEntriesToWrite = 0;
        if (bitCount <= 8 && requiredPaletteSize > actualPaletteSize) {
            numFakePaletteEntriesToWrite = (requiredPaletteSize - actualPaletteSize) / 4;
        }
        if (numFakePaletteEntriesToWrite > 0) {
            dataOffset += numFakePaletteEntriesToWrite * 4;
        }
        BitmapHelper.writeInt(out, dataOffset);
        byte[] bmi = rec.getBytesAt(bmiOffset, bmiSize);
        if (compressionType == 3) {
            bmi[16] = 0;
        }
        out.write(bmi);
        for (int index = 0; index < numFakePaletteEntriesToWrite; ++index) {
            BitmapHelper.writeInt(out, index);
        }
        byte[] bits = rec.getBytesAt(bitOffset, bitSize);
        out.write(bits);
        byte[] bmpData = out.toByteArray();
        ByteArrayInputStream stream = new ByteArrayInputStream(bmpData);
        BufferedImage image = ImageIO.read(stream);
        return image;
    }

    static int getNumberOfPaletteEntries(Record rec, int bmiOffset) throws IOException {
        int bmiSize = rec.getIntAt(bmiOffset);
        int numEntries = 0;
        if (bmiSize == 12) {
            short bitCount = rec.getShortAt(bmiOffset + 10);
            if (bitCount <= 8) {
                numEntries = 1 << bitCount;
            }
        } else {
            short bitCount = rec.getShortAt(bmiOffset + 14);
            numEntries = rec.getIntAt(bmiOffset + 32);
            if (numEntries == 0 && bitCount <= 8) {
                numEntries = 1 << bitCount;
            }
        }
        return numEntries;
    }

    static int getHeaderSize(Record rec, int bmiOffset, int usage) throws IOException {
        int numColorEntries = BitmapHelper.getNumberOfPaletteEntries(rec, bmiOffset);
        int bmiSize = rec.getIntAt(bmiOffset);
        int multiplier = 4;
        int size = 0;
        if (usage == 1) {
            multiplier = 2;
        }
        size = bmiSize == 12 ? 12 : 40;
        return size += numColorEntries * multiplier;
    }

    private static void writeInt(ByteArrayOutputStream out, int val) throws IOException {
        out.write((byte)(val & 0xFF));
        out.write((byte)(val >> 8 & 0xFF));
        out.write((byte)(val >> 16 & 0xFF));
        out.write((byte)(val >> 24 & 0xFF));
    }

    private static int applyRGBMask(int color, int redMask, int greenMask, int blueMask) {
        int shiftCount = BitmapHelper.getShiftCount(redMask);
        int maskSize = BitmapHelper.countBits(redMask);
        int red = (color & redMask) >>> shiftCount;
        red = red * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = BitmapHelper.getShiftCount(greenMask);
        maskSize = BitmapHelper.countBits(greenMask);
        int green = (color & greenMask) >>> shiftCount;
        green = green * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        shiftCount = BitmapHelper.getShiftCount(blueMask);
        maskSize = BitmapHelper.countBits(blueMask);
        int blue = (color & blueMask) >>> shiftCount;
        blue = blue * 255 / ((int)Math.pow(2.0, maskSize) - 1);
        Color foo = new Color(red, green, blue);
        color = foo.getRGB();
        return color;
    }

    private static int getShiftCount(int mask) {
        int count = 0;
        while (mask != 0 && (mask & 1) == 0) {
            mask >>>= 1;
            ++count;
        }
        return count;
    }

    private static int countBits(int mask) {
        int count = 0;
        for (int index = 0; index < 32; ++index) {
            if ((mask & 1) != 0) {
                ++count;
            }
            mask >>>= 1;
        }
        return count;
    }

    private static int flipBytes(int data) {
        int byte1 = data & 0xFF;
        int byte2 = (data & 0xFF00) >>> 8;
        int byte3 = (data & 0xFF0000) >>> 16;
        int byte4 = (data & 0xFF000000) >>> 24;
        data = byte1 << 24;
        data += byte2 << 16;
        data += byte3 << 8;
        return data += byte4;
    }
}

