/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.IRenderToPath;
import com.benryan.graphics.emf.IRenderableObject;
import com.benryan.graphics.emf.ITraceMe;
import com.benryan.graphics.emf.Record;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractTranscoder {
    private static boolean m_gDebugMode = false;
    private Dimension m_size = new Dimension(100, 100);
    private Graphics2D g;
    private int height;
    private int width;
    private String _thisClassName = null;

    static void setDebugMode() {
        m_gDebugMode = true;
    }

    static void logMessage(String message) {
        if (m_gDebugMode) {
            System.out.println(message);
        }
    }

    public void setSize(Dimension size) {
        this.g.scale((double)this.width / size.getWidth(), (double)this.height / size.getHeight());
        this.m_size = size;
    }

    public Dimension getSize() {
        return new Dimension(this.m_size);
    }

    public BufferedImage transcode(InputStream input, int width, int height) throws TranscoderException {
        if (input == null) {
            throw new IllegalArgumentException("Parameter 'input' may not be null");
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(input);
            this.width = width;
            this.height = height;
            BufferedImage img = new BufferedImage(width, height, 2);
            this.g = img.createGraphics();
            this.g.setPaint(new Color(255, 255, 255, 0));
            this.g.fill(new Rectangle(0, 0, width, height));
            this.g.draw(new Rectangle2D.Float(0.0f, 0.0f, width, height));
            this.doRender(width, height, stream);
            return img;
        }
        catch (IOException e) {
            throw new TranscoderException(e);
        }
    }

    public void transcode(InputStream input, Graphics2D g, int width, int height) throws TranscoderException {
        if (input == null) {
            throw new IllegalArgumentException("Parameter 'input' may not be null");
        }
        try {
            BufferedInputStream stream = new BufferedInputStream(input);
            this.width = width;
            this.height = height;
            this.g = g;
            this.doRender(width, height, stream);
        }
        catch (IOException e) {
            throw new TranscoderException(e);
        }
    }

    private void doRender(int width, int height, BufferedInputStream stream) throws TranscoderException, IOException {
        this.iterateRecords(stream, this.g);
    }

    private void iterateRecords(BufferedInputStream stream, Graphics2D g) throws TranscoderException, IOException {
        Record rec;
        DeviceContext context = new DeviceContext();
        int index = 0;
        while ((rec = this.getNextRecord(stream, index)) != null) {
            ++index;
            try {
                String output = null;
                IRenderableObject svgConverter = this.getConverter(rec);
                if (svgConverter != null) {
                    if (context.getGdiPath().isOpen() && svgConverter instanceof IRenderToPath) {
                        IRenderToPath pathRender = (IRenderToPath)((Object)svgConverter);
                        pathRender.render(context);
                        if (m_gDebugMode) {
                            output = this.buildOutput(rec, "IRenderToPath", index);
                        }
                    } else {
                        svgConverter.render(g, context);
                        if (m_gDebugMode) {
                            output = this.buildOutput(rec, "IRenderableObject", index);
                        }
                    }
                    if (m_gDebugMode && svgConverter instanceof ITraceMe) {
                        output = output + ' ' + svgConverter.toString();
                    }
                } else {
                    output = this.buildOutput(rec, "Unhandled", index);
                }
                AbstractTranscoder.logMessage(output);
            }
            catch (TranscoderException e) {
                throw e;
            }
            catch (Exception e) {
                String output = this.buildOutput(rec, "Exception while processing", index) + ":\n" + e.toString();
                AbstractTranscoder.logMessage(output);
                e.printStackTrace();
            }
        }
    }

    private String buildOutput(Record rec, String msg, int ix) {
        if (this._thisClassName == null) {
            this._thisClassName = this.getClass().getName();
            this._thisClassName = this._thisClassName.substring(this._thisClassName.lastIndexOf(46) + 1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._thisClassName);
        sb.append(", record " + ix + ' ');
        sb.append(msg + "  metafile record type ");
        sb.append(rec.getType() + " = " + this.getUserFriendlyName(rec.getType()));
        return sb.toString();
    }

    protected abstract Record getNextRecord(BufferedInputStream var1, int var2) throws IOException;

    protected abstract IRenderableObject getConverter(Record var1) throws TranscoderException;

    protected abstract String getUserFriendlyName(int var1);
}

