/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.DeviceContext;
import com.benryan.graphics.emf.IEmf2SvgConverter;
import com.benryan.graphics.emf.IRenderToPath;
import com.benryan.graphics.emf.IWmf2SvgConverter;
import com.benryan.graphics.emf.Record;
import com.benryan.graphics.emf.TranscoderException;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;

abstract class AbstractPolyPoly
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath {
    private static final int EMF_N_POLYS_OFFSET = 16;
    private static final int EMF_COUNT_POINTS_OFFSET = 20;
    private static final int EMF_COUNTS_OFFSET = 24;
    private static final int WMF_N_POLYS_OFFSET = 0;
    private static final int WMF_COUNTS_OFFSET = 2;
    private int m_nPolys = 0;
    private int m_nPoints = 0;
    private int[] m_nPointsInPoly = null;
    private int[] m_xPointList = null;
    private int[] m_yPointList = null;
    private boolean m_b16Bit = true;

    public AbstractPolyPoly(boolean b16Bit) {
        this.m_b16Bit = b16Bit;
    }

    @Override
    public void readWMFRecord(Record emr) throws IOException {
        this.m_nPolys = emr.getShortAt(0);
        this.m_nPointsInPoly = new int[this.m_nPolys];
        this.m_nPoints = 0;
        for (int i = 0; i < this.m_nPolys; ++i) {
            this.m_nPointsInPoly[i] = emr.getShortAt(2 + i * 2);
            this.m_nPoints += this.m_nPointsInPoly[i];
        }
        this.m_xPointList = new int[this.m_nPoints];
        this.m_yPointList = new int[this.m_nPoints];
        int curOffset = 2 + this.m_nPolys * 2;
        for (int i = 0; i < this.m_nPoints; ++i) {
            this.m_xPointList[i] = emr.getShortAt(curOffset);
            this.m_yPointList[i] = emr.getShortAt(curOffset + 2);
            curOffset += 4;
        }
    }

    @Override
    public void readEMFRecord(Record emr) throws IOException {
        this.m_nPolys = emr.getIntAt(16);
        this.m_nPoints = emr.getIntAt(20);
        this.m_nPointsInPoly = new int[this.m_nPolys];
        this.m_xPointList = new int[this.m_nPoints];
        this.m_yPointList = new int[this.m_nPoints];
        for (int i = 0; i < this.m_nPolys; ++i) {
            this.m_nPointsInPoly[i] = emr.getIntAt(24 + i * 4);
        }
        int curOffset = 24 + this.m_nPolys * 4;
        for (int i = 0; i < this.m_nPoints; ++i) {
            if (this.m_b16Bit) {
                this.m_xPointList[i] = emr.getShortAt(curOffset);
                this.m_yPointList[i] = emr.getShortAt(curOffset + 2);
                curOffset += 4;
                continue;
            }
            this.m_xPointList[i] = emr.getIntAt(curOffset);
            this.m_yPointList[i] = emr.getIntAt(curOffset + 4);
            curOffset += 8;
        }
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        int curOffset = 0;
        for (int i = 0; i < this.m_nPolys; ++i) {
            int numPoints = this.m_nPointsInPoly[i];
            int[] xPoints = new int[numPoints];
            int[] yPoints = new int[numPoints];
            for (int j = 0; j < numPoints; ++j) {
                xPoints[j] = context.convertXToSVGLogicalUnits(this.m_xPointList[curOffset]);
                yPoints[j] = context.convertYToSVGLogicalUnits(this.m_yPointList[curOffset]);
                ++curOffset;
            }
            this.renderPoly(g, context, xPoints, yPoints, numPoints);
        }
    }

    @Override
    public void render(DeviceContext context) {
        int curOffset = 0;
        GeneralPath p = new GeneralPath();
        for (int i = 0; i < this.m_nPolys; ++i) {
            int numPoints = this.m_nPointsInPoly[i];
            int[] xPoints = new int[numPoints];
            int[] yPoints = new int[numPoints];
            for (int j = 0; j < numPoints; ++j) {
                xPoints[j] = context.convertXToSVGLogicalUnits(this.m_xPointList[curOffset]);
                yPoints[j] = context.convertYToSVGLogicalUnits(this.m_yPointList[curOffset]);
                ++curOffset;
            }
            this.renderPoly(p, xPoints, yPoints, numPoints);
        }
        context.getGdiPath().appendFigure(p);
    }

    protected abstract boolean renderPoly(Graphics2D var1, DeviceContext var2, int[] var3, int[] var4, int var5);

    protected abstract boolean renderPoly(GeneralPath var1, int[] var2, int[] var3, int var4);
}

