/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.emf;

import com.benryan.graphics.emf.IEmf2SvgConverter;
import com.benryan.graphics.emf.IRenderToPath;
import com.benryan.graphics.emf.ITraceMe;
import com.benryan.graphics.emf.IWmf2SvgConverter;
import com.benryan.graphics.emf.Record;
import java.io.IOException;

abstract class AbstractPoly
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath,
ITraceMe {
    private static final int EMF_POINT_COUNT_OFFSET = 16;
    private static final int EMF_POINT_ARRAY_START = 20;
    private static final int WMF_POINT_COUNT_OFFSET = 0;
    private static final int WMF_POINT_ARRAY_START = 2;
    private int m_count = 0;
    private int[] m_xPoints = null;
    private int[] m_yPoints = null;
    private boolean m_b16Bits = true;
    protected int[] m_xPointsConv = null;
    protected int[] m_yPointsConv = null;

    public AbstractPoly(boolean b16Bits) {
        this.m_b16Bits = b16Bits;
    }

    @Override
    public void readWMFRecord(Record emr) throws IOException {
        this.m_count = emr.getShortAt(0);
        this.readPoly(emr, 2);
    }

    @Override
    public void readEMFRecord(Record emr) throws IOException {
        this.m_count = emr.getIntAt(16);
        this.readPoly(emr, 20);
    }

    protected int getCount() {
        return this.m_count;
    }

    protected int[] getXPoints() {
        return this.m_xPoints;
    }

    protected int[] getYPoints() {
        return this.m_yPoints;
    }

    private boolean readPoly(Record emr, int pointOffset) throws IOException {
        this.m_xPoints = new int[this.m_count];
        this.m_yPoints = new int[this.m_count];
        int curPos = pointOffset;
        for (int i = 0; i < this.m_count; ++i) {
            if (this.m_b16Bits) {
                this.m_xPoints[i] = emr.getShortAt(curPos);
                this.m_yPoints[i] = emr.getShortAt(curPos + 2);
                curPos += 4;
                continue;
            }
            this.m_xPoints[i] = emr.getIntAt(curPos);
            this.m_yPoints[i] = emr.getIntAt(curPos + 4);
            curPos += 8;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("cnt=" + this.m_count);
        this.dumpPoints(sb, ", Converted:", this.m_xPointsConv, this.m_yPointsConv);
        this.dumpPoints(sb, ", Original:", this.m_xPoints, this.m_yPoints);
        return sb.toString();
    }

    private void dumpPoints(StringBuffer sb, String what, int[] x, int[] y) {
        sb.append(what);
        if (x == null || y == null) {
            sb.append(" (null)");
        } else {
            for (int ix = 0; ix < this.m_count; ++ix) {
                sb.append(" (" + x[ix] + ',' + y[ix] + ')');
            }
        }
    }
}

