/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api.usermodel;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherArrayProperty;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherOptRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherSimpleProperty;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.EscherTextboxRecord;
import com.benryan.escher.api.UnknownEscherRecord;
import com.benryan.escher.api.usermodel.ITextBox;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.escher.api.usermodel.ShapeGroup;
import com.benryan.escher.api.usermodel.SimpleShape;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.model.EscherHostTextContainer;
import com.benryan.ppt.api.record.OEPlaceholderAtom;
import com.benryan.ppt.api.record.RecordTypes;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class TextBox
extends SimpleShape
implements ITextBox {
    public static final int AnchorTop = 0;
    public static final int AnchorMiddle = 1;
    public static final int AnchorBottom = 2;
    public static final int AnchorTopCentered = 3;
    public static final int AnchorMiddleCentered = 4;
    public static final int AnchorBottomCentered = 5;
    public static final int AnchorTopBaseline = 6;
    public static final int AnchorBottomBaseline = 7;
    public static final int AnchorTopCenteredBaseline = 8;
    public static final int AnchorBottomCenteredBaseline = 9;
    public static final int WrapSquare = 0;
    public static final int WrapByPoints = 1;
    public static final int WrapNone = 2;
    public static final int WrapTopBottom = 3;
    public static final int WrapThrough = 4;
    public static final int AlignLeft = 0;
    public static final int AlignCenter = 1;
    public static final int AlignRight = 2;
    public static final int AlignJustify = 3;
    protected EscherTextboxRecord _textbox;
    private int lastTitleIdx;
    private boolean _missingTextRecords = false;

    public static boolean doesShapeHaveText(Shape test) {
        return Shape.getEscherChild(test.getSpContainer(), -4083) != null;
    }

    @Override
    public boolean isHFlipped() {
        return false;
    }

    public TextBox() {
        this(null);
    }

    public TextBox(EscherContainerRecord escherRecord, IShape parent) {
        super(escherRecord, parent);
        this._textbox = (EscherTextboxRecord)Shape.getEscherChild(this._escherContainer, -4083);
    }

    public TextBox(IShape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(parent instanceof ShapeGroup);
    }

    public EscherTextboxRecord getEscherRecord() {
        return this._textbox;
    }

    @Override
    public int getMarginBottom() {
        ITextBox master;
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 132);
        if (prop == null && (prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 769)) != null && (master = this.findMaster(prop.getPropertyValue())) != null) {
            return master.getMarginBottom();
        }
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return val / 9525;
    }

    @Override
    public int getMarginLeft() {
        ITextBox master;
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 129);
        if (prop == null && (prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 769)) != null && (master = this.findMaster(prop.getPropertyValue())) != null) {
            return master.getMarginLeft();
        }
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return val / 9525;
    }

    @Override
    public int getMarginRight() {
        ITextBox master;
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 131);
        if (prop == null && (prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 769)) != null && (master = this.findMaster(prop.getPropertyValue())) != null) {
            return master.getMarginRight();
        }
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return val / 9525;
    }

    @Override
    public int getMarginTop() {
        ITextBox master;
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 130);
        if (prop == null && (prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 769)) != null && (master = this.findMaster(prop.getPropertyValue())) != null) {
            return master.getMarginTop();
        }
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return val / 9525;
    }

    public OEPlaceholderAtom getPlaceHolderInfo() {
        UnknownEscherRecord rawAtom;
        EscherRecord clientData = TextBox.getEscherChild(this._escherContainer, -4079);
        if (clientData instanceof EscherContainerRecord && (rawAtom = (UnknownEscherRecord)TextBox.getEscherChild((EscherContainerRecord)clientData, RecordTypes.OEPlaceholderAtom.typeID)) != null) {
            return new OEPlaceholderAtom(rawAtom.getData(), 0, 8);
        }
        return null;
    }

    public int getTextId() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 128);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    @Override
    public Rectangle getTextRectangle(Rectangle2D anchor) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherArrayProperty prop = (EscherArrayProperty)TextBox.getEscherProperty(opt, 343);
        if (prop != null && prop.getNumberOfElementsInArray() > 0) {
            byte[] buf = prop.getElement(0);
            int offset = 0;
            int left = TextBox.handleGuideIndex(LittleEndian.getInt(buf, offset));
            int top = TextBox.handleGuideIndex(LittleEndian.getInt(buf, offset += 4));
            int right = TextBox.handleGuideIndex(LittleEndian.getInt(buf, offset += 4));
            int bottom = TextBox.handleGuideIndex(LittleEndian.getInt(buf, offset += 4));
            double scaleX = anchor.getWidth() / 21600.0;
            double scaleY = anchor.getHeight() / 21600.0;
            left = (int)((double)left * scaleX);
            right = (int)((double)right * scaleX);
            top = (int)((double)top * scaleY);
            bottom = (int)((double)bottom * scaleY);
            Rectangle rec = new Rectangle((int)((double)left + anchor.getX()), (int)((double)top + anchor.getY()), right - left, bottom - top);
            return rec;
        }
        return null;
    }

    @Override
    public int getVerticalAlignment() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 135);
        int valign = -1;
        if (prop == null) {
            ITextBox master;
            prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 769);
            if (prop != null && (master = this.findMaster(prop.getPropertyValue())) != null) {
                return master.getVerticalAlignment();
            }
        } else {
            valign = prop.getPropertyValue();
        }
        return valign;
    }

    @Override
    public int getWordWrap() {
        ITextBox master;
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 133);
        if (prop == null && (prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 769)) != null && (master = this.findMaster(prop.getPropertyValue())) != null) {
            return master.getWordWrap();
        }
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setBackgroundColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
        TextBox.setEscherProperty(opt, (short)387, rgb);
    }

    public void setMarginBottom(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)132, margin * 9525);
    }

    public void setMarginLeft(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)129, margin * 9525);
    }

    public void setMarginRight(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)131, margin * 9525);
    }

    public void setMarginTop(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)130, margin * 9525);
    }

    public void setTextId(int id) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)128, id);
    }

    public void setVerticalAlignment(int align) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)135, align);
    }

    public void setWordWrap(int wrap) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)133, wrap);
    }

    @Override
    public boolean shouldRender(boolean isMaster) {
        return this.getHostObject().shouldRenderText(this, isMaster);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherContainerRecord spcont = super.createSpContainer(isChild);
        EscherSpRecord spRecord = spcont.getChildById((short)-4086);
        short type = 3234;
        spRecord.setOptions(type);
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(spcont, -4085);
        TextBox.setEscherProperty(opt, (short)128, 0);
        TextBox.setEscherProperty(opt, (short)385, 0x8000004);
        TextBox.setEscherProperty(opt, (short)387, 0x8000000);
        TextBox.setEscherProperty(opt, (short)447, 0x100000);
        TextBox.setEscherProperty(opt, (short)448, 0x8000001);
        TextBox.setEscherProperty(opt, (short)511, 524288);
        TextBox.setEscherProperty(opt, (short)513, 0x8000002);
        return spcont;
    }

    private ITextBox findMaster(int shapeID) {
        Shape master = this._hostObj.findMasterShape(shapeID);
        if (master == null) {
            return null;
        }
        if (master instanceof TextBox) {
            return (ITextBox)((Object)master);
        }
        return new TextBox(master._escherContainer, master._parent);
    }

    @Override
    public EscherHostTextContainer getEscherHostTextContainer() {
        return this.getHostObject().getTextContainer(this);
    }
}

