/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api.usermodel;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherChildAnchorRecord;
import com.benryan.escher.api.EscherClientAnchorRecord;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherOptRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherSimpleProperty;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.ppt.api.IShape;
import java.awt.Color;

public class SimpleShape
extends Shape {
    protected SimpleShape(EscherContainerRecord escherRecord, IShape parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherRecord anchor;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        EscherSpRecord sp = new EscherSpRecord();
        int flags = 2560;
        if (isChild) {
            flags |= 2;
        }
        sp.setFlags(flags);
        spContainer.addChildRecord(sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        spContainer.addChildRecord(opt);
        if (isChild) {
            anchor = new EscherChildAnchorRecord();
        } else {
            anchor = new EscherClientAnchorRecord();
            byte[] header = new byte[16];
            LittleEndian.putUShort(header, 0, 0);
            LittleEndian.putUShort(header, 2, 0);
            LittleEndian.putInt(header, 4, 8);
            anchor.fillFields(header, 0, null);
        }
        spContainer.addChildRecord(anchor);
        return spContainer;
    }

    public double getLineWidth() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        if (opt == null) {
            return 1.0;
        }
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 459);
        return prop == null ? 1.0 : (double)prop.getPropertyValue() / 9525.0;
    }

    public void setLineWidth(double width) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)459, (int)(width * 9525.0));
    }

    public void setLineColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
        SimpleShape.setEscherProperty(opt, (short)448, rgb);
        SimpleShape.setEscherProperty(opt, (short)511, color == null ? 0x180010 : 0x180018);
    }

    public Color getLineColor() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        if (opt == null) {
            return Color.black;
        }
        EscherSimpleProperty p1 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 448);
        EscherSimpleProperty p2 = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 511);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        Color clr = null;
        if (p1 != null && (p2val & 8) != 0) {
            int rgb = p1.getPropertyValue();
            clr = this._host.getHostColor(rgb);
        }
        if (clr == null && p1 == null && p2 == null) {
            return Color.black;
        }
        return clr;
    }

    public int getLineDashing() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 462);
        return prop == null ? 1 : prop.getPropertyValue();
    }

    public void setLineDashing(int pen) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)462, pen == 1 ? -1 : pen);
    }

    public void setLineStyle(int style) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)461, style == 0 ? -1 : style);
    }

    public int getLineStyle() {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)SimpleShape.getEscherProperty(opt, 461);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setFillColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)SimpleShape.getEscherChild(this._escherContainer, -4085);
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
        SimpleShape.setEscherProperty(opt, (short)385, rgb);
        SimpleShape.setEscherProperty(opt, (short)447, color == null ? 0x150010 : 0x150011);
    }
}

