/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api.usermodel;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.api.EscherClientAnchorRecord;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.EscherSpgrRecord;
import com.benryan.escher.api.usermodel.Hyperlink;
import com.benryan.escher.api.usermodel.IShapeGroup;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.escher.api.usermodel.ShapeFactory;
import com.benryan.ppt.api.IShape;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ShapeGroup
extends Shape
implements IShapeGroup {
    public ShapeGroup() {
        this(null, null);
        this._escherContainer = this.createSpContainer(false);
    }

    protected ShapeGroup(EscherContainerRecord escherRecord, IShape parent) {
        super(escherRecord, parent);
    }

    public Shape[] getShapes() {
        List<EscherRecord> lst = this._escherContainer.getChildRecords();
        ArrayList<Shape> shapeList = new ArrayList<Shape>(lst.size());
        for (int i = 1; i < lst.size(); ++i) {
            EscherRecord r = lst.get(i);
            if (r instanceof EscherContainerRecord) {
                EscherContainerRecord container = (EscherContainerRecord)r;
                Shape shape = ShapeFactory.createShape(container, this);
                shape.setHostObject(this.getHostObject());
                shapeList.add(shape);
                continue;
            }
            this.logger.log(7, "Shape contained non container escher record, was " + r.getClass().getName());
        }
        return shapeList.toArray(new Shape[shapeList.size()]);
    }

    @Override
    public void setAnchor(Rectangle anchor) {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChildRecords().get(0);
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)ShapeGroup.getEscherChild(spContainer, -4080);
        byte[] header = new byte[16];
        LittleEndian.putUShort(header, 0, 0);
        LittleEndian.putUShort(header, 2, 0);
        LittleEndian.putInt(header, 4, 8);
        clientAnchor.fillFields(header, 0, null);
        clientAnchor.setFlag((short)(anchor.y * 576 / 96));
        clientAnchor.setCol1((short)(anchor.x * 576 / 96));
        clientAnchor.setDx1((short)((anchor.width + anchor.x) * 576 / 96));
        clientAnchor.setRow1((short)((anchor.height + anchor.y) * 576 / 96));
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeGroup.getEscherChild(spContainer, -4087);
        spgr.setRectX1(anchor.x * 576 / 96);
        spgr.setRectY1(anchor.y * 576 / 96);
        spgr.setRectX2((anchor.x + anchor.width) * 576 / 96);
        spgr.setRectY2((anchor.y + anchor.height) * 576 / 96);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherContainerRecord spgr = new EscherContainerRecord();
        spgr.setRecordId((short)-4093);
        spgr.setOptions((short)15);
        EscherContainerRecord spcont = new EscherContainerRecord();
        spcont.setRecordId((short)-4092);
        spcont.setOptions((short)15);
        EscherSpgrRecord spg = new EscherSpgrRecord();
        spg.setOptions((short)1);
        spcont.addChildRecord(spg);
        EscherSpRecord sp = new EscherSpRecord();
        short type = 2;
        sp.setOptions(type);
        sp.setFlags(513);
        spcont.addChildRecord(sp);
        EscherClientAnchorRecord anchor = new EscherClientAnchorRecord();
        spcont.addChildRecord(anchor);
        spgr.addChildRecord(spcont);
        return spgr;
    }

    public void addShape(Shape shape) {
        this._escherContainer.addChildRecord(shape.getSpContainer());
        shape.setHostObject(this._hostObj);
        shape.afterInsert(this._hostObj);
    }

    @Override
    public void moveTo(int x, int y) {
        Shape[] shape;
        Rectangle anchor = this.getAnchor();
        int dx = x - anchor.x;
        int dy = y - anchor.y;
        anchor.translate(dx, dy);
        this.setAnchor(anchor);
        for (Shape aShape : shape = this.getShapes()) {
            Rectangle chanchor = aShape.getAnchorInternal();
            chanchor.translate(dx, dy);
            aShape.setAnchor(chanchor);
        }
    }

    @Override
    public Rectangle getAnchor() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeGroup.getEscherChild(groupInfoContainer, -4087);
        Rectangle anchor = new Rectangle();
        anchor.x = spgr.getRectX1() * 96 / 576;
        anchor.y = spgr.getRectY1() * 96 / 576;
        anchor.width = (spgr.getRectX2() - spgr.getRectX1()) * 96 / 576;
        anchor.height = (spgr.getRectY2() - spgr.getRectY1()) * 96 / 576;
        return anchor;
    }

    @Override
    public Rectangle2D getTransformedAnchor() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        return super.getAnchorFromContainer(groupInfoContainer);
    }

    @Override
    public int getShapeType() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpRecord spRecord = groupInfoContainer.getChildById((short)-4086);
        return spRecord.getOptions() >> 4;
    }

    @Override
    public int getShapeId() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpRecord spRecord = groupInfoContainer.getChildById((short)-4086);
        return spRecord.getShapeId();
    }

    @Override
    public Hyperlink getHyperlink() {
        return null;
    }

    @Override
    public AffineTransform getChildTransform(AffineTransform anchorTransform) {
        Rectangle2D rec1 = this.getTransformedAnchor();
        Rectangle rec = this.getAnchor();
        double scaleX = rec1.getWidth() / rec.getWidth();
        double scaleY = rec1.getHeight() / rec.getHeight();
        AffineTransform oldTransform = new AffineTransform();
        if (anchorTransform != null) {
            oldTransform = anchorTransform;
        }
        AffineTransform newTransform = new AffineTransform(oldTransform);
        newTransform.scale(scaleX, scaleY);
        newTransform.translate(0.0 - rec.getX(), 0.0 - rec.getY());
        newTransform.translate(rec1.getX() / scaleX, rec1.getY() / scaleY);
        return newTransform;
    }
}

