/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api.usermodel;

import com.benryan.apache.poi.util.POILogFactory;
import com.benryan.apache.poi.util.POILogger;
import com.benryan.escher.api.EscherChildAnchorRecord;
import com.benryan.escher.api.EscherClientAnchorRecord;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherOptRecord;
import com.benryan.escher.api.EscherProperty;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherSimpleProperty;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.usermodel.DrawingHost;
import com.benryan.escher.api.usermodel.Fill;
import com.benryan.escher.api.usermodel.HostEnvironment;
import com.benryan.escher.api.usermodel.Hyperlink;
import com.benryan.escher.api.usermodel.ShapeTypes;
import com.benryan.ppt.api.IShape;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Shape
implements IShape {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    public EscherContainerRecord _escherContainer;
    protected IShape _parent;
    protected HostEnvironment _host;
    protected DrawingHost _hostObj;
    protected Map _hostProps = new HashMap();

    protected Shape(EscherContainerRecord escherRecord, IShape parent) {
        this._escherContainer = escherRecord;
        this._parent = parent;
    }

    protected abstract EscherContainerRecord createSpContainer(boolean var1);

    public IShape getParent() {
        return this._parent;
    }

    public int getShapeId() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        return spRecord.getShapeId();
    }

    public String getShapeName() {
        return ShapeTypes.typeName(this.getShapeType());
    }

    public int getShapeType() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        return spRecord.getOptions() >> 4;
    }

    public void setShapeType(int type) {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        spRecord.setOptions((short)(type << 4 | 2));
    }

    public EscherContainerRecord getEscherContainer() {
        return this._escherContainer;
    }

    @Override
    public Rectangle2D getAnchor() {
        return this.getAnchorInternal();
    }

    public Rectangle getAnchorInternal() {
        return this.getAnchorFromContainer(this._escherContainer);
    }

    protected Rectangle getAnchorFromContainer(EscherContainerRecord escherContainer) {
        EscherRecord rec;
        EscherSpRecord spRecord = escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        Rectangle anchor = null;
        if ((flags & 2) != 0 && (rec = (EscherChildAnchorRecord)Shape.getEscherChild(escherContainer, -4081)) != null) {
            anchor = new Rectangle();
            anchor.x = ((EscherChildAnchorRecord)rec).getDx1() * 96 / 576;
            anchor.y = ((EscherChildAnchorRecord)rec).getDy1() * 96 / 576;
            anchor.width = ((EscherChildAnchorRecord)rec).getDx2() * 96 / 576 - anchor.x;
            anchor.height = ((EscherChildAnchorRecord)rec).getDy2() * 96 / 576 - anchor.y;
        }
        if (anchor == null) {
            rec = Shape.getEscherChild(escherContainer, -4080);
            anchor = this._hostObj.getAnchor(this, rec);
        }
        return anchor;
    }

    public void setAnchor(Rectangle anchor) {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        if ((flags & 2) != 0) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)Shape.getEscherChild(this._escherContainer, -4081);
            rec.setDx1(anchor.x * 576 / 96);
            rec.setDy1(anchor.y * 576 / 96);
            rec.setDx2((anchor.width + anchor.x) * 576 / 96);
            rec.setDy2((anchor.height + anchor.y) * 576 / 96);
        } else {
            EscherClientAnchorRecord rec = (EscherClientAnchorRecord)Shape.getEscherChild(this._escherContainer, -4080);
            rec.setFlag((short)(anchor.y * 576 / 96));
            rec.setCol1((short)(anchor.x * 576 / 96));
            rec.setDx1((short)((anchor.width + anchor.x) * 576 / 96));
            rec.setRow1((short)((anchor.height + anchor.y) * 576 / 96));
        }
    }

    public void moveTo(int x, int y) {
        Rectangle anchor = this.getAnchorInternal();
        anchor.setLocation(x, y);
        this.setAnchor(anchor);
    }

    public static EscherRecord getEscherChild(EscherContainerRecord owner, int recordId) {
        for (EscherRecord escherRecord : owner.getChildRecords()) {
            if (escherRecord.getRecordId() != recordId) continue;
            return escherRecord;
        }
        return null;
    }

    public static EscherProperty getEscherProperty(EscherOptRecord opt, int propId) {
        if (opt == null) {
            return null;
        }
        for (EscherProperty prop : opt.getEscherProperties()) {
            if (prop.getPropertyNumber() != propId) continue;
            return prop;
        }
        return null;
    }

    public static void setEscherProperty(EscherOptRecord opt, short propId, int value) {
        List props = opt.getEscherProperties();
        Iterator iterator = props.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = (EscherProperty)iterator.next();
            if (prop.getId() != propId) continue;
            iterator.remove();
        }
        if (value != -1) {
            opt.addEscherProperty(new EscherSimpleProperty(propId, value));
            opt.sortProperties();
        }
    }

    public EscherContainerRecord getSpContainer() {
        return this._escherContainer;
    }

    public void afterInsert(DrawingHost sheet) {
        this._host.afterInsert(this, sheet);
    }

    public DrawingHost getHostObject() {
        return this._hostObj;
    }

    public void setHostObject(DrawingHost sheet) {
        this._hostObj = sheet;
        if (sheet != null) {
            this._host = this._hostObj.getEnvironment();
            sheet.initShape(this);
        }
    }

    protected Color getColor(int rgb) {
        return this._host.getHostColor(rgb);
    }

    public Fill getFill() {
        return new Fill(this);
    }

    @Override
    public float getRotation() {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, 4);
        if (prop != null) {
            return prop.getPropertyValue() >> 16;
        }
        return 0.0f;
    }

    public Hyperlink getHyperlink() {
        return this._host.getHyperlink(this);
    }

    @Override
    public boolean isHFlipped() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        return (spRecord.getFlags() & 0x40) != 0;
    }

    @Override
    public boolean isVFlipped() {
        EscherSpRecord spRecord = this._escherContainer.getChildById((short)-4086);
        return (spRecord.getFlags() & 0x80) != 0;
    }

    public void setHostSpecificProp(Object key, Object val) {
        this._hostProps.put(key, val);
    }

    public Object getHostSpecificProp(Object key) {
        return this._hostProps.get(key);
    }

    @Override
    public Color getFillColor() {
        if (this._escherContainer == null) {
            return Color.white;
        }
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        if (opt == null) {
            return Color.white;
        }
        EscherSimpleProperty p1 = (EscherSimpleProperty)Shape.getEscherProperty(opt, 385);
        EscherSimpleProperty p2 = (EscherSimpleProperty)Shape.getEscherProperty(opt, 447);
        EscherSimpleProperty p3 = (EscherSimpleProperty)Shape.getEscherProperty(opt, 386);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        Color clr = null;
        if (p1 != null && (p2val & 0x10) != 0) {
            int rgb = p1.getPropertyValue();
            clr = this._host.getHostColor(rgb);
        }
        if (p3 != null && clr != null) {
            double opacity = (double)(p3.getPropertyValue() & 0xFFFFF) / 65536.0;
            clr = new Color(clr.getRed(), clr.getGreen(), clr.getBlue(), Math.min((int)(255.0 * opacity), 255));
        }
        return clr;
    }

    @Override
    public boolean isBackgroundShape() {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, 831);
        return prop != null && prop.getPropertyValue() != 0;
    }

    public static int handleGuideIndex(int short1) {
        if (short1 >= Integer.MIN_VALUE && short1 <= -2147483521) {
            return 0;
        }
        return short1;
    }

    @Override
    public AffineTransform createAutoShapeTransform(Rectangle2D logicalRec, Rectangle2D rec, AffineTransform oldt) {
        AffineTransform newt = new AffineTransform(oldt);
        float rotation = this.getRotation();
        if (rotation < 0.0f) {
            rotation = 360.0f - (0.0f - rotation);
        }
        if (rotation != 0.0f && (rotation >= 45.0f && rotation < 135.0f || rotation >= 225.0f && rotation < 315.0f)) {
            int halfWidth = (int)rec.getWidth() + 1 >> 1;
            int halfHeight = (int)rec.getHeight() + 1 >> 1;
            Point topLeft = new Point((int)rec.getX() + halfWidth - halfHeight, (int)rec.getY() + halfHeight - halfWidth);
            rec = new Rectangle2D.Double(topLeft.x, topLeft.y, rec.getHeight(), rec.getWidth());
        }
        newt.translate(rec.getX(), rec.getY());
        if (this.isHFlipped()) {
            newt.translate(rec.getWidth(), 0.0);
            newt.scale(-1.0, 1.0);
        }
        if (this.isVFlipped()) {
            newt.translate(0.0, rec.getHeight());
            newt.scale(1.0, -1.0);
        }
        if (rotation != 0.0f) {
            double radians = Math.toRadians(rotation);
            newt.translate(rec.getWidth() / 2.0, rec.getHeight() / 2.0);
            newt.rotate(radians);
            newt.translate(0.0 - rec.getWidth() / 2.0, 0.0 - rec.getHeight() / 2.0);
        }
        if (rec != logicalRec) {
            newt.scale(rec.getWidth() / logicalRec.getWidth(), rec.getHeight() / logicalRec.getHeight());
        }
        newt.translate(0.0 - logicalRec.getX(), 0.0 - logicalRec.getY());
        return newt;
    }
}

