/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api.usermodel;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.ppt.api.IPictureData;
import com.benryan.ppt.api.blip.DIB;
import com.benryan.ppt.api.blip.EMF;
import com.benryan.ppt.api.blip.JPEG;
import com.benryan.ppt.api.blip.PICT;
import com.benryan.ppt.api.blip.PNG;
import com.benryan.ppt.api.blip.WMF;
import com.benryan.ppt.api.exceptions.HSLFException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class PictureData
implements IPictureData {
    protected static final int CHECKSUM_SIZE = 16;
    private byte[] rawdata;
    protected int offset;

    @Override
    public abstract int getType();

    @Override
    public abstract byte[] getData();

    public abstract void setData(byte[] var1) throws IOException;

    protected abstract int getSignature();

    public byte[] getRawData() {
        return this.rawdata;
    }

    public void setRawData(byte[] data) {
        String extension = "";
        switch (this.getType()) {
            case 2: {
                extension = "emf";
                break;
            }
            case 3: {
                extension = "wmf";
                break;
            }
            case 4: {
                extension = "pic";
                break;
            }
            case 5: {
                extension = "jpg";
                break;
            }
            case 6: {
                extension = "png";
                break;
            }
            case 7: {
                extension = "dib";
            }
        }
        this.rawdata = data;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getUID() {
        byte[] uid = new byte[16];
        System.arraycopy(this.rawdata, 0, uid, 0, uid.length);
        return uid;
    }

    public static byte[] getChecksum(byte[] data) {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HSLFException(e.getMessage());
        }
        sha.update(data);
        return sha.digest();
    }

    public void write(OutputStream out) throws IOException {
        byte[] data = new byte[2];
        LittleEndian.putUShort(data, 0, this.getSignature());
        out.write(data);
        data = new byte[2];
        LittleEndian.putUShort(data, 0, this.getType() + 61464);
        out.write(data);
        byte[] rawdata = this.getRawData();
        data = new byte[4];
        LittleEndian.putInt(data, 0, rawdata.length);
        out.write(data);
        out.write(rawdata);
    }

    public static PictureData create(int type) {
        PictureData pict;
        switch (type) {
            case 2: {
                pict = new EMF();
                break;
            }
            case 3: {
                pict = new WMF();
                break;
            }
            case 4: {
                pict = new PICT();
                break;
            }
            case 5: {
                pict = new JPEG();
                break;
            }
            case 6: {
                pict = new PNG();
                break;
            }
            case 7: {
                pict = new DIB();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported picture type: " + type);
            }
        }
        return pict;
    }

    public byte[] getHeader() {
        byte[] header = new byte[24];
        LittleEndian.putInt(header, 0, this.getSignature());
        LittleEndian.putInt(header, 4, this.getRawData().length);
        System.arraycopy(this.rawdata, 0, header, 8, 16);
        return header;
    }

    public int getSize() {
        return this.getData().length;
    }
}

