/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api.usermodel;

import com.benryan.escher.api.EscherBSERecord;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherOptRecord;
import com.benryan.escher.api.EscherRecord;
import com.benryan.escher.api.EscherSimpleProperty;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.escher.api.usermodel.ShapeGroup;
import com.benryan.escher.api.usermodel.SimpleShape;
import com.benryan.ppt.api.IPicture;
import com.benryan.ppt.api.IPictureData;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.api.util.EscherImageOptions;
import com.benryan.ppt.api.util.ImageOptions;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class Picture
extends SimpleShape
implements IPicture {
    public Picture(int idx) {
        this(idx, null);
    }

    public Picture(int idx, IShape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(idx, parent instanceof ShapeGroup);
    }

    protected Picture(EscherContainerRecord escherRecord, IShape parent) {
        super(escherRecord, parent);
    }

    public int getPictureIndex() {
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Picture.getEscherProperty(opt, 260);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public double getCropTop() {
        return this.getCrop((short)256);
    }

    public double getCropLeft() {
        return this.getCrop((short)258);
    }

    public double getCropRight() {
        return this.getCrop((short)259);
    }

    public double getCropBottom() {
        return this.getCrop((short)257);
    }

    private double getCrop(short propType) {
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Picture.getEscherProperty(opt, propType);
        if (prop != null && prop.getPropertyValue() > 0) {
            int test = (prop.getPropertyValue() & 0xFFFF) * 1000 >> 16;
            return (double)test / 1000.0;
        }
        return 0.0;
    }

    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        EscherContainerRecord spContainer = super.createSpContainer(isChild);
        spContainer.setOptions((short)15);
        EscherSpRecord spRecord = spContainer.getChildById((short)-4086);
        spRecord.setOptions((short)1202);
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(spContainer, -4085);
        Picture.setEscherProperty(opt, (short)127, 0x800080);
        Picture.setEscherProperty(opt, (short)16644, idx);
        return spContainer;
    }

    public void setDefaultSize() {
        IPictureData pict = this.getPictureData();
        BufferedImage img = null;
        try {
            img = ImageIO.read(new ByteArrayInputStream(pict.getData()));
        }
        catch (IOException iOException) {
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            // empty catch block
        }
        if (img != null) {
            this.setAnchor(new Rectangle(0, 0, img.getWidth(), img.getHeight()));
        } else {
            this.setAnchor(new Rectangle(0, 0, 200, 200));
        }
    }

    public Color getTransparency() {
        EscherOptRecord opt = (EscherOptRecord)Picture.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Picture.getEscherProperty(opt, 263);
        if (prop != null) {
            return this._host.getHostColor(prop.getPropertyValue());
        }
        return null;
    }

    @Override
    public IPictureData getPictureData() {
        EscherContainerRecord dggContainer = this._host.getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)Shape.getEscherChild(dggContainer, -4095);
        if (bstore != null) {
            List<EscherRecord> lst = bstore.getChildRecords();
            int idx = this.getPictureIndex();
            if (idx == 0) {
                this.logger.log(7, "no reference to picture data found ");
            } else {
                EscherBSERecord bse = (EscherBSERecord)lst.get(idx - 1);
                return this._host.getImage(bse);
            }
        }
        return null;
    }

    @Override
    public ImageOptions getImageOptions() {
        return new EscherImageOptions(this.getEscherContainer(), this.getHostObject().getEnvironment());
    }
}

