/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.escher.api.usermodel;

import com.benryan.apache.poi.util.LittleEndian;
import com.benryan.escher.BinaryCustomShapeRenderer;
import com.benryan.escher.CustomShapeRenderer;
import com.benryan.escher.api.EscherArrayProperty;
import com.benryan.escher.api.EscherContainerRecord;
import com.benryan.escher.api.EscherOptRecord;
import com.benryan.escher.api.EscherSimpleProperty;
import com.benryan.escher.api.EscherSpRecord;
import com.benryan.escher.api.usermodel.ITextBox;
import com.benryan.escher.api.usermodel.PathInfo;
import com.benryan.escher.api.usermodel.PathOp;
import com.benryan.escher.api.usermodel.Shape;
import com.benryan.escher.api.usermodel.ShapeGroup;
import com.benryan.escher.api.usermodel.SimpleShape;
import com.benryan.escher.api.usermodel.TextBox;
import com.benryan.ppt.api.IAutoShape;
import com.benryan.ppt.api.IShape;
import com.benryan.ppt.autoshapes.Autoshape;
import com.benryan.ppt.autoshapes.gen.ShapeFinder;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class AutoShape
extends SimpleShape
implements IAutoShape {
    private static final int NON_PRIMITIVE = 0;
    private static final int LINE_TO = 0;
    private static final int CURVE_TO = 1;
    private static final int MOVE_TO = 2;
    private static final int CLOSE = 3;
    private static final int END = 4;
    private static final int ESCAPE = 5;
    private static final int MORE_POINTS = 0;
    private static final int ANGLE_ELLIPSE_TO = 1;
    private static final int ANGLE_ELLIPSE = 2;
    private static final int ARC_TO = 3;
    private static final int ARC = 4;
    private static final int CLOCKWISE_ARC_TO = 5;
    private static final int CLOCKWISE_ARC = 6;
    private static final int ELLIPTICAL_QUAD_X = 7;
    private static final int ELLIPTICAL_QUAD_Y = 8;
    private static final int QUAD_BEZ = 9;
    private static final int NO_STROKE = 11;
    private static final int NO_FILL = 10;
    private static final int CLIENT_ESCAPE = 6;
    private static final int ROUNDED_RECTANGLE = 2;

    protected AutoShape(EscherContainerRecord escherRecord, IShape parent) {
        super(escherRecord, parent);
    }

    public AutoShape(int type, IShape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(type, parent instanceof ShapeGroup);
    }

    public AutoShape(int type) {
        this(type, null);
    }

    public double[] getAdjustments() {
        ArrayList adjustments = new ArrayList();
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        if (opt != null) {
            this.addAdjustment(adjustments, opt, (short)327);
            this.addAdjustment(adjustments, opt, (short)328);
            this.addAdjustment(adjustments, opt, (short)329);
            this.addAdjustment(adjustments, opt, (short)330);
            this.addAdjustment(adjustments, opt, (short)331);
            this.addAdjustment(adjustments, opt, (short)332);
            this.addAdjustment(adjustments, opt, (short)333);
            this.addAdjustment(adjustments, opt, (short)334);
            this.addAdjustment(adjustments, opt, (short)335);
            this.addAdjustment(adjustments, opt, (short)336);
        }
        double[] retVal = new double[adjustments.size()];
        for (int x = 0; x < retVal.length; ++x) {
            retVal[x] = ((Integer)adjustments.get(x)).doubleValue();
        }
        return retVal;
    }

    public EscherArrayProperty getSegmentArray() {
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        return (EscherArrayProperty)AutoShape.getEscherProperty(opt, 326);
    }

    public EscherArrayProperty getVertices() {
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        return (EscherArrayProperty)AutoShape.getEscherProperty(opt, 325);
    }

    public EscherArrayProperty getGuides() {
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        return (EscherArrayProperty)AutoShape.getEscherProperty(opt, 342);
    }

    private void addAdjustment(List adjustments, EscherOptRecord opt, short propType) {
        EscherSimpleProperty prop = (EscherSimpleProperty)AutoShape.getEscherProperty(opt, propType);
        if (prop != null) {
            int adjustment = prop.getPropertyValue();
            adjustments.add(new Integer(adjustment));
        }
    }

    public int getAutoShapeType() {
        EscherContainerRecord spcont = super.getSpContainer();
        EscherSpRecord spRecord = spcont.getChildById((short)-4086);
        return spRecord.getOptions() >> 4;
    }

    protected EscherContainerRecord createSpContainer(int shapeType, boolean isChild) {
        EscherContainerRecord spcont = super.createSpContainer(isChild);
        EscherSpRecord spRecord = spcont.getChildById((short)-4086);
        short type = (short)(shapeType << 4 | 2);
        spRecord.setOptions(type);
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(spcont, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(385, 0x8000004));
        opt.addEscherProperty(new EscherSimpleProperty(387, 0x8000000));
        opt.addEscherProperty(new EscherSimpleProperty(447, 0x100010));
        opt.addEscherProperty(new EscherSimpleProperty(448, 0x8000001));
        opt.addEscherProperty(new EscherSimpleProperty(511, 524296));
        opt.addEscherProperty(new EscherSimpleProperty(513, 0x8000002));
        return spcont;
    }

    public double getMinX() {
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)AutoShape.getEscherProperty(opt, 320);
        if (prop != null) {
            return prop.getPropertyValue();
        }
        return 0.0;
    }

    public double getMinY() {
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)AutoShape.getEscherProperty(opt, 321);
        if (prop != null) {
            return prop.getPropertyValue();
        }
        return 0.0;
    }

    public double getMaxX() {
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)AutoShape.getEscherProperty(opt, 322);
        if (prop != null) {
            return prop.getPropertyValue();
        }
        return 21600.0;
    }

    public double getMaxY() {
        EscherOptRecord opt = (EscherOptRecord)AutoShape.getEscherChild(super.getSpContainer(), -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)AutoShape.getEscherProperty(opt, 323);
        if (prop != null) {
            return prop.getPropertyValue();
        }
        return 21600.0;
    }

    @Override
    public Autoshape getPredefinedShape(Rectangle2D rec) {
        int type = this.getAutoShapeType();
        Autoshape shapeRender = ShapeFinder.getAutoShape(type);
        double[] adjustments = this.getAdjustments();
        if (type == 2) {
            double[] adjustHack = new double[]{adjustments.length > 0 ? adjustments[0] : 5400.0, rec.getWidth() / (this.getMaxX() - this.getMinX()), rec.getHeight() / (this.getMaxY() - this.getMinY())};
            adjustments = adjustHack;
        }
        if (shapeRender != null) {
            shapeRender.initShape(adjustments);
        }
        return shapeRender;
    }

    public List<PathInfo> getPathOperations() {
        EscherArrayProperty segments = this.getSegmentArray();
        EscherArrayProperty vertices = this.getVertices();
        ArrayList<PathInfo> pathOps = new ArrayList<PathInfo>();
        int arrSize = segments.getNumberOfElementsInArray();
        if (arrSize == 0) {
            double[] vertPoints = this.getVertices(vertices, 0, 1, null);
            pathOps.add(new PathInfo(PathOp.MOVE_TO, vertPoints));
            vertPoints = this.getVertices(vertices, 1, vertices.getNumberOfElementsInArray() - 1, null);
            pathOps.add(new PathInfo(PathOp.LINE_TO, vertPoints));
            pathOps.add(new PathInfo(PathOp.CLOSE, null));
            pathOps.add(new PathInfo(PathOp.END, null));
        } else {
            int vertIdx = 0;
            double[] extra = null;
            block21: for (int x = 0; x < arrSize; ++x) {
                short val = LittleEndian.getShort(segments.getElement(x));
                int operation = (val & 0xE000) >> 13;
                int numVerts = val & 0x1FFF;
                switch (operation) {
                    case 2: {
                        double[] vertPoints = this.getVertices(vertices, vertIdx, 1, null);
                        pathOps.add(new PathInfo(PathOp.MOVE_TO, vertPoints));
                        ++vertIdx;
                        continue block21;
                    }
                    case 0: {
                        for (int y = 0; y < numVerts; ++y) {
                            double[] vertPoints = this.getVertices(vertices, vertIdx, 1, null);
                            pathOps.add(new PathInfo(PathOp.LINE_TO, vertPoints));
                            ++vertIdx;
                        }
                        continue block21;
                    }
                    case 1: {
                        for (int y = 0; y < numVerts; ++y) {
                            double[] vertPoints = this.getVertices(vertices, vertIdx, 3, null);
                            pathOps.add(new PathInfo(PathOp.CURVE_TO, vertPoints));
                            vertIdx += 3;
                        }
                        continue block21;
                    }
                    case 3: {
                        pathOps.add(new PathInfo(PathOp.CLOSE, null));
                        continue block21;
                    }
                    case 4: {
                        pathOps.add(new PathInfo(PathOp.END, null));
                        continue block21;
                    }
                    case 5: 
                    case 6: {
                        int escapeOp = (numVerts & 0x1F00) >> 8;
                        int escapeNumVerts = numVerts & 0xFF;
                        switch (escapeOp) {
                            case 0: {
                                extra = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                break;
                            }
                            case 1: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.ANGLE_ELLIPSE_TO, vertPoints));
                                break;
                            }
                            case 2: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.ANGLE_ELLIPSE, vertPoints));
                                break;
                            }
                            case 3: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.ARC_TO, vertPoints));
                                break;
                            }
                            case 5: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.CLOCKWISE_ARC_TO, vertPoints));
                                break;
                            }
                            case 6: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.CLOCKWISE_ARC, vertPoints));
                                break;
                            }
                            case 7: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.ELLIPTICAL_QUAD_X, vertPoints));
                                break;
                            }
                            case 8: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.ELLIPTICAL_QUAD_Y, vertPoints));
                                break;
                            }
                            case 9: {
                                double[] vertPoints = this.getVertices(vertices, vertIdx, escapeNumVerts, extra);
                                pathOps.add(new PathInfo(PathOp.QUAD_BEZ, vertPoints));
                                break;
                            }
                            case 10: {
                                pathOps.add(new PathInfo(PathOp.NO_FILL, null));
                                break;
                            }
                            case 11: {
                                pathOps.add(new PathInfo(PathOp.NO_STROKE, null));
                            }
                        }
                        if (escapeOp != 0) {
                            extra = null;
                        }
                        vertIdx += escapeNumVerts;
                        continue block21;
                    }
                }
            }
        }
        return pathOps;
    }

    @Override
    public boolean isUserDefined() {
        int type = this.getAutoShapeType();
        return type == 0 || type == 100;
    }

    private double[] getVertices(EscherArrayProperty vertices, int vertIdx, int i, double[] extra) {
        double[] retVal = new double[i * 2 + (extra != null ? extra.length : 0)];
        for (int x = 0; x < i; ++x) {
            byte[] val = vertices.getElement(vertIdx + x);
            if (val.length == 4) {
                retVal[x * 2] = Shape.handleGuideIndex(LittleEndian.getUShort(val));
                retVal[x * 2 + 1] = Shape.handleGuideIndex(LittleEndian.getUShort(val, 2));
                continue;
            }
            retVal[x * 2] = Shape.handleGuideIndex(LittleEndian.getInt(val));
            retVal[x * 2 + 1] = Shape.handleGuideIndex(LittleEndian.getInt(val, 4));
        }
        if (extra != null) {
            System.arraycopy(extra, 0, retVal, i * 2, extra.length);
        }
        return retVal;
    }

    @Override
    public CustomShapeRenderer getCustomShapeRenderer() {
        return new BinaryCustomShapeRenderer();
    }

    @Override
    public boolean doesShapeHaveText() {
        return TextBox.doesShapeHaveText(this);
    }

    @Override
    public ITextBox getTextBox() {
        TextBox txbx = new TextBox(this.getSpContainer(), this.getParent());
        txbx.setHostObject(this.getHostObject());
        return txbx;
    }
}

